"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderEndpointInfo = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _endpoint_agent_status = require("../../../../../../common/components/endpoint/endpoint_agent_status");
var _header_agent_info = require("../header_agent_info");
var _hooks = require("../../../../../hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HeaderEndpointInfo = exports.HeaderEndpointInfo = /*#__PURE__*/(0, _react.memo)(({
  endpointId
}) => {
  const {
    data: endpointDetails,
    isLoading
  } = (0, _hooks.useGetEndpointDetails)(endpointId, {
    refetchInterval: 10000
  });
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 2
    });
  }
  if (!endpointDetails) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_header_agent_info.HeaderAgentInfo, {
    platform: endpointDetails.metadata.host.os.name.toLowerCase(),
    hostName: endpointDetails.metadata.host.name,
    lastCheckin: endpointDetails.last_checkin
  }, /*#__PURE__*/_react.default.createElement(_endpoint_agent_status.EndpointAgentStatus, {
    endpointHostInfo: endpointDetails,
    "data-test-subj": "responderHeaderEndpointAgentIsolationStatus"
  }));
});
HeaderEndpointInfo.displayName = 'HeaderEndpointInfo';