"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointAppliedPolicyStatus = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _host_constants = require("../../pages/endpoint_hosts/view/host_constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Displays the status of an applied policy on the Endpoint (using the information provided
 * by the endpoint in the Metadata document `Endpoint.policy.applied`.
 * By default, the policy status is displayed as plain text, however, that can be overridden
 * by defining the `children` prop or passing a child component to this one.
 */

/**
 * Display the status of the Policy applied on an endpoint
 */
const EndpointAppliedPolicyStatus = exports.EndpointAppliedPolicyStatus = /*#__PURE__*/(0, _react.memo)(({
  policyApplied,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpointPolicyStatus.tooltipTitleLabel",
      defaultMessage: "Policy applied"
    }),
    anchorClassName: "eui-textTruncate",
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s",
      alignItems: "center",
      "data-test-subj": "endpointAppliedPolicyTooltipInfo"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "eui-textTruncate",
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      className: "eui-textTruncate"
    }, policyApplied.name)), policyApplied.endpoint_policy_version && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs",
      style: {
        whiteSpace: 'nowrap',
        paddingLeft: '6px'
      },
      className: "eui-textTruncate",
      "data-test-subj": "policyRevision"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpointPolicyStatus.revisionNumber",
      defaultMessage: "rev. {revNumber}",
      values: {
        revNumber: policyApplied.endpoint_policy_version
      }
    }))))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: _host_constants.POLICY_STATUS_TO_HEALTH_COLOR[policyApplied.status],
    className: "eui-textTruncate eui-fullWidth",
    "data-test-subj": "policyStatus"
  }, children !== undefined ? children : _host_constants.POLICY_STATUS_TO_TEXT[policyApplied.status]));
});
EndpointAppliedPolicyStatus.displayName = 'EndpointAppliedPolicyStatus';