"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArgumentFileSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INITIAL_DISPLAY_LABEL = _i18n.i18n.translate('xpack.securitySolution.consoleArgumentSelectors.fileSelector.initialDisplayLabel', {
  defaultMessage: 'Click to select file'
});
const OPEN_FILE_PICKER_LABEL = _i18n.i18n.translate('xpack.securitySolution.consoleArgumentSelectors.fileSelector.filePickerButtonLabel', {
  defaultMessage: 'Open file picker'
});
const NO_FILE_SELECTED = _i18n.i18n.translate('xpack.securitySolution.consoleArgumentSelectors.fileSelector.noFileSelected', {
  defaultMessage: 'No file selected'
});
/**
 * A Console Argument Selector component that enables the user to select a file from the local machine
 */
const ArgumentFileSelector = exports.ArgumentFileSelector = /*#__PURE__*/(0, _react.memo)(({
  value,
  valueText,
  onChange,
  store: _store
}) => {
  const state = (0, _react.useMemo)(() => {
    return _store !== null && _store !== void 0 ? _store : {
      isPopoverOpen: true
    };
  }, [_store]);
  const setIsPopoverOpen = (0, _react.useCallback)(newValue => {
    onChange({
      value,
      valueText,
      store: {
        ...state,
        isPopoverOpen: newValue
      }
    });
  }, [onChange, state, value, valueText]);
  const filePickerUUID = (0, _react.useMemo)(() => {
    return (0, _eui.htmlIdGenerator)('console')();
  }, []);
  const handleOpenPopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(true);
  }, [setIsPopoverOpen]);
  const handleClosePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, [setIsPopoverOpen]);
  const handleFileSelection = (0, _react.useCallback)(selectedFiles => {
    // Get only the first file selected
    const file = selectedFiles === null || selectedFiles === void 0 ? void 0 : selectedFiles.item(0);
    onChange({
      value: file !== null && file !== void 0 ? file : undefined,
      valueText: file ? file.name : '',
      store: {
        ...state,
        isPopoverOpen: false
      }
    });
  }, [onChange, state]);
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: state.isPopoverOpen,
    closePopover: handleClosePopover,
    anchorPosition: "upCenter",
    initialFocus: `#${filePickerUUID}`,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      alignItems: "center",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: "eui-textTruncate",
      onClick: handleOpenPopover
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "eui-textTruncate",
      title: valueText || NO_FILE_SELECTED
    }, valueText || INITIAL_DISPLAY_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "folderOpen",
      size: "xs",
      onClick: handleOpenPopover,
      "aria-label": OPEN_FILE_PICKER_LABEL
    })))
  }, state.isPopoverOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    id: filePickerUUID,
    onChange: handleFileSelection,
    fullWidth: true,
    display: "large",
    "data-test-subj": "console-arg-file-picker"
  })));
});
ArgumentFileSelector.displayName = 'ArgumentFileSelector';