"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLoadPoliciesError = exports.TRUSTED_APPS_TAB = exports.POLICIES_TAB = exports.OS_TITLES = exports.EVENT_FILTERS_TAB = exports.ENDPOINTS_TAB = exports.CONSOLE_COMMANDS = exports.CONFIRM_WARNING_MODAL_LABELS = void 0;
var _i18n = require("@kbn/i18n");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENDPOINTS_TAB = exports.ENDPOINTS_TAB = _i18n.i18n.translate('xpack.securitySolution.endpointsTab', {
  defaultMessage: 'Endpoints'
});
const POLICIES_TAB = exports.POLICIES_TAB = _i18n.i18n.translate('xpack.securitySolution.policiesTab', {
  defaultMessage: 'Policies'
});
const TRUSTED_APPS_TAB = exports.TRUSTED_APPS_TAB = _i18n.i18n.translate('xpack.securitySolution.trustedAppsTab', {
  defaultMessage: 'Trusted applications'
});
const EVENT_FILTERS_TAB = exports.EVENT_FILTERS_TAB = _i18n.i18n.translate('xpack.securitySolution.eventFiltersTab', {
  defaultMessage: 'Event filters'
});
const OS_TITLES = exports.OS_TITLES = {
  [_securitysolutionUtils.OperatingSystem.WINDOWS]: _i18n.i18n.translate('xpack.securitySolution.administration.os.windows', {
    defaultMessage: 'Windows'
  }),
  [_securitysolutionUtils.OperatingSystem.MAC]: _i18n.i18n.translate('xpack.securitySolution.administration.os.macos', {
    defaultMessage: 'Mac'
  }),
  [_securitysolutionUtils.OperatingSystem.LINUX]: _i18n.i18n.translate('xpack.securitySolution.administration.os.linux', {
    defaultMessage: 'Linux'
  })
};
const getLoadPoliciesError = error => {
  return _i18n.i18n.translate('xpack.securitySolution.exceptions.failedLoadPolicies', {
    defaultMessage: 'There was an error loading policies: "{error}"',
    values: {
      error: error.message
    }
  });
};
exports.getLoadPoliciesError = getLoadPoliciesError;
const CONSOLE_COMMANDS = exports.CONSOLE_COMMANDS = {
  isolate: {
    title: _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.isolate.title', {
      defaultMessage: 'Isolate'
    }),
    about: _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.isolate.about', {
      defaultMessage: 'Isolate the host'
    }),
    privileges: _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.isolate.privileges', {
      defaultMessage: 'Insufficient privileges to isolate hosts. Contact your Kibana administrator if you think you should have this permission.'
    })
  },
  release: {
    about: _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.release.about', {
      defaultMessage: 'Release the host'
    })
  },
  killProcess: {
    title: _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.killProcess.title', {
      defaultMessage: 'Kill process'
    }),
    about: _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.killProcess.about', {
      defaultMessage: 'Kill/terminate a process'
    }),
    privileges: _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.killProcess.privileges', {
      defaultMessage: 'Insufficient privileges to kill process. Contact your Kibana administrator if you think you should have this permission.'
    }),
    args: {
      pid: {
        about: _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.pid.arg.comment', {
          defaultMessage: 'A PID representing the process to kill'
        })
      },
      entityId: {
        about: _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.entityId.arg.comment', {
          defaultMessage: 'An entity id representing the process to kill'
        })
      }
    }
  },
  suspendProcess: {
    title: _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.suspendProcess.title', {
      defaultMessage: 'Suspend process'
    }),
    about: _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.suspendProcess.about', {
      defaultMessage: 'Temporarily suspend a process'
    }),
    privileges: _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.suspendProcess.privileges', {
      defaultMessage: 'Insufficient privileges to supend process. Contact your Kibana administrator if you think you should have this permission.'
    }),
    args: {
      pid: {
        about: _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.suspendProcess.pid.arg.comment', {
          defaultMessage: 'A PID representing the process to suspend'
        })
      },
      entityId: {
        about: _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.suspendProcess.entityId.arg.comment', {
          defaultMessage: 'An entity id representing the process to suspend'
        })
      }
    }
  },
  status: {
    about: _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.status.about', {
      defaultMessage: 'Show host status information'
    })
  },
  processes: {
    about: _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.processes.about', {
      defaultMessage: 'Show all running processes'
    })
  },
  getFile: {
    about: _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.getFile.about', {
      defaultMessage: 'Retrieve a file from the host'
    }),
    args: {
      path: {
        about: _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.getFile.pathArgAbout', {
          defaultMessage: 'The full file path to be retrieved'
        })
      }
    }
  },
  execute: {
    about: _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.execute.about', {
      defaultMessage: 'Execute a command on the host'
    }),
    args: {
      timeout: {
        about: _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.execute.args.timeout.about', {
          defaultMessage: 'The timeout in units of time (h for hours, m for minutes, s for seconds) for the endpoint to wait for the script to complete. Example: 37m. If not given, it defaults to 4 hours.'
        })
      }
    }
  },
  upload: {
    about: _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.upload.about', {
      defaultMessage: 'Upload a file to the host'
    }),
    args: {
      file: {
        about: _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.upload.args.file.about', {
          defaultMessage: 'The file that will be sent to the host'
        })
      },
      overwrite: {
        about: _i18n.i18n.translate('xpack.securitySolution.endpointConsoleCommands.upload.args.overwrite.about', {
          defaultMessage: 'Overwrite the file on the host if it already exists'
        })
      }
    }
  }
};
const CONFIRM_WARNING_MODAL_LABELS = entryType => {
  return {
    title: _i18n.i18n.translate('xpack.securitySolution.artifacts.confirmWarningModal.title', {
      defaultMessage: `Confirm {type}`,
      values: {
        type: entryType
      }
    }),
    body: _i18n.i18n.translate('xpack.securitySolution.artifacts.confirmWarningModal.body', {
      defaultMessage: 'Using a "*" or a "?" in the value with the "IS" operator can make the entry ineffective. Change the operator to ‘matches’ to ensure wildcards run properly. Select “cancel” to revise your entry, or "add" to continue with the entry in its current state.'
    }),
    confirmButton: _i18n.i18n.translate('xpack.securitySolution.artifacts.confirmWarningModal.confirmButtonText', {
      defaultMessage: 'Add'
    }),
    cancelButton: _i18n.i18n.translate('xpack.securitySolution.trustedapps.confirmWarningModal.cancelButtonText', {
      defaultMessage: 'Cancel'
    })
  };
};
exports.CONFIRM_WARNING_MODAL_LABELS = CONFIRM_WARNING_MODAL_LABELS;