"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserPanelKey = exports.UserPanel = exports.USER_PANEL_RISK_SCORE_QUERY_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _kibana_react = require("../../../common/lib/kibana/kibana_react");
var _use_risk_score = require("../../../entity_analytics/api/hooks/use_risk_score");
var _managed_details = require("../../../../common/search_strategy/security_solution/users/managed_details");
var _use_managed_user = require("../../../timelines/components/side_panel/new_user_detail/hooks/use_managed_user");
var _manage_query = require("../../../common/components/page/manage_query");
var _model = require("../../../explore/users/store/model");
var _get_criteria_from_users_type = require("../../../common/components/ml/criteria/get_criteria_from_users_type");
var _use_global_time = require("../../../common/containers/use_global_time");
var _anomaly_table_provider = require("../../../common/components/ml/anomaly/anomaly_table_provider");
var _search_strategy = require("../../../../common/search_strategy");
var _risk_engine = require("../../../../common/entity_analytics/risk_engine");
var _flyout_loading = require("../../shared/components/flyout_loading");
var _flyout_navigation = require("../../shared/components/flyout_navigation");
var _content = require("./content");
var _header = require("./header");
var _user_details_left = require("../user_details_left");
var _use_observed_user = require("./hooks/use_observed_user");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserPanelKey = exports.UserPanelKey = 'user-panel';
const USER_PANEL_RISK_SCORE_QUERY_ID = exports.USER_PANEL_RISK_SCORE_QUERY_ID = 'userPanelRiskScoreQuery';
const FIRST_RECORD_PAGINATION = {
  cursorStart: 0,
  querySize: 1
};
const UserPanel = ({
  contextID,
  scopeId,
  userName,
  isDraggable
}) => {
  var _observedUser$details, _managedUser$data, _managedUser$data2;
  const {
    telemetry
  } = (0, _kibana_react.useKibana)().services;
  const userNameFilterQuery = (0, _react.useMemo)(() => userName ? (0, _search_strategy.buildUserNamesFilter)([userName]) : undefined, [userName]);
  const riskScoreState = (0, _use_risk_score.useRiskScore)({
    riskEntity: _risk_engine.RiskScoreEntity.user,
    filterQuery: userNameFilterQuery,
    onlyLatest: false,
    pagination: FIRST_RECORD_PAGINATION
  });
  const {
    inspect,
    refetch,
    loading
  } = riskScoreState;
  const {
    to,
    from,
    isInitializing,
    setQuery,
    deleteQuery
  } = (0, _use_global_time.useGlobalTime)();
  const observedUser = (0, _use_observed_user.useObservedUser)(userName, scopeId);
  const email = (_observedUser$details = observedUser.details.user) === null || _observedUser$details === void 0 ? void 0 : _observedUser$details.email;
  const managedUser = (0, _use_managed_user.useManagedUser)(userName, email, observedUser.isLoading);
  const {
    data: userRisk
  } = riskScoreState;
  const userRiskData = userRisk && userRisk.length > 0 ? userRisk[0] : undefined;
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect,
    loading,
    queryId: USER_PANEL_RISK_SCORE_QUERY_ID,
    refetch,
    setQuery
  });
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const openPanelTab = (0, _react.useCallback)(tab => {
    var _userRiskData$user;
    telemetry.reportRiskInputsExpandedFlyoutOpened({
      entity: 'user'
    });
    openLeftPanel({
      id: _user_details_left.UserDetailsPanelKey,
      params: {
        isRiskScoreExist: !!(userRiskData !== null && userRiskData !== void 0 && (_userRiskData$user = userRiskData.user) !== null && _userRiskData$user !== void 0 && _userRiskData$user.risk),
        user: {
          name: userName,
          email
        }
      },
      path: tab ? {
        tab
      } : undefined
    });
  }, [telemetry, email, openLeftPanel, userName, userRiskData]);
  const openPanelFirstTab = (0, _react.useCallback)(() => openPanelTab(), [openPanelTab]);
  const hasUserDetailsData = !!(userRiskData !== null && userRiskData !== void 0 && userRiskData.user.risk) || !!((_managedUser$data = managedUser.data) !== null && _managedUser$data !== void 0 && _managedUser$data[_managed_details.ManagedUserDatasetKey.OKTA]) || !!((_managedUser$data2 = managedUser.data) !== null && _managedUser$data2 !== void 0 && _managedUser$data2[_managed_details.ManagedUserDatasetKey.ENTRA]);
  if (riskScoreState.loading || observedUser.isLoading || managedUser.isLoading) {
    return /*#__PURE__*/_react.default.createElement(_flyout_loading.FlyoutLoading, null);
  }
  return /*#__PURE__*/_react.default.createElement(_anomaly_table_provider.AnomalyTableProvider, {
    criteriaFields: (0, _get_criteria_from_users_type.getCriteriaFromUsersType)(_model.UsersType.details, userName),
    startDate: from,
    endDate: to,
    skip: isInitializing
  }, ({
    isLoadingAnomaliesData,
    anomaliesData,
    jobNameById
  }) => {
    const observedUserWithAnomalies = {
      ...observedUser,
      anomalies: {
        isLoading: isLoadingAnomaliesData,
        anomalies: anomaliesData,
        jobNameById
      }
    };
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_navigation.FlyoutNavigation, {
      flyoutIsExpandable: hasUserDetailsData,
      expandDetails: openPanelFirstTab
    }), /*#__PURE__*/_react.default.createElement(_header.UserPanelHeader, {
      userName: userName,
      observedUser: observedUserWithAnomalies,
      managedUser: managedUser
    }), /*#__PURE__*/_react.default.createElement(_content.UserPanelContent, {
      userName: userName,
      managedUser: managedUser,
      observedUser: observedUserWithAnomalies,
      riskScoreState: riskScoreState,
      contextID: contextID,
      scopeId: scopeId,
      isDraggable: !!isDraggable,
      openDetailsPanel: openPanelTab
    }));
  });
};
exports.UserPanel = UserPanel;
UserPanel.displayName = 'UserPanel';