"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEntityTableColumns = void 0;
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _uiTheme = require("@kbn/ui-theme");
var _i18nReact = require("@kbn/i18n-react");
var _field_renderers = require("../../../../../timelines/components/field_renderers/field_renderers");
var _empty_value = require("../../../../../common/components/empty_value");
var _helpers = require("../../../../../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEntityTableColumns = (contextID, scopeId, isDraggable, data) => [{
  name: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.fieldColumnTitle",
    defaultMessage: "Field"
  }),
  field: 'label',
  render: (label, {
    field
  }) => /*#__PURE__*/_react2.default.createElement("span", {
    "data-test-subj": "entity-table-label",
    css: (0, _react.css)`
          font-weight: ${_uiTheme.euiThemeVars.euiFontWeightMedium};
          color: ${_uiTheme.euiThemeVars.euiTitleColor};
        `
  }, label !== null && label !== void 0 ? label : field)
}, {
  name: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.valuesColumnTitle",
    defaultMessage: "Values"
  }),
  field: 'field',
  render: (field, {
    getValues,
    render,
    renderField
  }) => {
    const values = getValues && getValues(data);
    if (field) {
      return /*#__PURE__*/_react2.default.createElement(_field_renderers.DefaultFieldRenderer, {
        rowItems: values,
        attrName: field,
        idPrefix: contextID ? `entityTable-${contextID}` : 'entityTable',
        isDraggable: isDraggable,
        sourcererScopeId: (0, _helpers.getSourcererScopeId)(scopeId),
        scopeId: scopeId,
        render: renderField,
        "data-test-subj": "entity-table-value"
      });
    }
    if (render) {
      return render(data);
    }
    return (0, _empty_value.getEmptyTagValue)();
  }
}];
exports.getEntityTableColumns = getEntityTableColumns;