"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostPanelKey = exports.HostPanel = exports.HOST_PANEL_RISK_SCORE_QUERY_ID = exports.HOST_PANEL_OBSERVED_HOST_QUERY_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _kibana_react = require("../../../common/lib/kibana/kibana_react");
var _host_to_criteria = require("../../../common/components/ml/criteria/host_to_criteria");
var _use_risk_score = require("../../../entity_analytics/api/hooks/use_risk_score");
var _manage_query = require("../../../common/components/page/manage_query");
var _use_global_time = require("../../../common/containers/use_global_time");
var _search_strategy = require("../../../../common/search_strategy");
var _risk_engine = require("../../../../common/entity_analytics/risk_engine");
var _flyout_loading = require("../../shared/components/flyout_loading");
var _flyout_navigation = require("../../shared/components/flyout_navigation");
var _content = require("./content");
var _header = require("./header");
var _anomaly_table_provider = require("../../../common/components/ml/anomaly/anomaly_table_provider");
var _use_observed_host = require("./hooks/use_observed_host");
var _host_details_left = require("../host_details_left");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HostPanelKey = exports.HostPanelKey = 'host-panel';
const HOST_PANEL_RISK_SCORE_QUERY_ID = exports.HOST_PANEL_RISK_SCORE_QUERY_ID = 'HostPanelRiskScoreQuery';
const HOST_PANEL_OBSERVED_HOST_QUERY_ID = exports.HOST_PANEL_OBSERVED_HOST_QUERY_ID = 'HostPanelObservedHostQuery';
const FIRST_RECORD_PAGINATION = {
  cursorStart: 0,
  querySize: 1
};
const HostPanel = ({
  contextID,
  scopeId,
  hostName,
  isDraggable
}) => {
  const {
    telemetry
  } = (0, _kibana_react.useKibana)().services;
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    to,
    from,
    isInitializing,
    setQuery,
    deleteQuery
  } = (0, _use_global_time.useGlobalTime)();
  const hostNameFilterQuery = (0, _react.useMemo)(() => hostName ? (0, _search_strategy.buildHostNamesFilter)([hostName]) : undefined, [hostName]);
  const riskScoreState = (0, _use_risk_score.useRiskScore)({
    riskEntity: _risk_engine.RiskScoreEntity.host,
    filterQuery: hostNameFilterQuery,
    onlyLatest: false,
    pagination: FIRST_RECORD_PAGINATION
  });
  const {
    data: hostRisk,
    inspect: inspectRiskScore,
    refetch,
    loading
  } = riskScoreState;
  const hostRiskData = hostRisk && hostRisk.length > 0 ? hostRisk[0] : undefined;
  const isRiskScoreExist = !!(hostRiskData !== null && hostRiskData !== void 0 && hostRiskData.host.risk);
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect: inspectRiskScore,
    loading,
    queryId: HOST_PANEL_RISK_SCORE_QUERY_ID,
    refetch,
    setQuery
  });
  const openTabPanel = (0, _react.useCallback)(tab => {
    telemetry.reportRiskInputsExpandedFlyoutOpened({
      entity: 'host'
    });
    openLeftPanel({
      id: _host_details_left.HostDetailsPanelKey,
      params: {
        name: hostName,
        isRiskScoreExist,
        path: tab ? {
          tab
        } : undefined
      }
    });
  }, [telemetry, openLeftPanel, hostName, isRiskScoreExist]);
  const openDefaultPanel = (0, _react.useCallback)(() => openTabPanel(), [openTabPanel]);
  const observedHost = (0, _use_observed_host.useObservedHost)(hostName, scopeId);
  if (riskScoreState.loading || observedHost.isLoading) {
    return /*#__PURE__*/_react.default.createElement(_flyout_loading.FlyoutLoading, null);
  }
  return /*#__PURE__*/_react.default.createElement(_anomaly_table_provider.AnomalyTableProvider, {
    criteriaFields: (0, _host_to_criteria.hostToCriteria)(observedHost.details),
    startDate: from,
    endDate: to,
    skip: isInitializing
  }, ({
    isLoadingAnomaliesData,
    anomaliesData,
    jobNameById
  }) => {
    const observedHostWithAnomalies = {
      ...observedHost,
      anomalies: {
        isLoading: isLoadingAnomaliesData,
        anomalies: anomaliesData,
        jobNameById
      }
    };
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_navigation.FlyoutNavigation, {
      flyoutIsExpandable: isRiskScoreExist,
      expandDetails: openDefaultPanel
    }), /*#__PURE__*/_react.default.createElement(_header.HostPanelHeader, {
      hostName: hostName,
      observedHost: observedHostWithAnomalies
    }), /*#__PURE__*/_react.default.createElement(_content.HostPanelContent, {
      hostName: hostName,
      observedHost: observedHostWithAnomalies,
      riskScoreState: riskScoreState,
      contextID: contextID,
      scopeId: scopeId,
      isDraggable: !!isDraggable,
      openDetailsPanel: openTabPanel
    }));
  });
};
exports.HostPanel = HostPanel;
HostPanel.displayName = 'HostPanel';