"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostPanelContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _asset_criticality_selector = require("../../../entity_analytics/components/asset_criticality/asset_criticality_selector");
var _risk_summary = require("../../../entity_analytics/components/risk_summary_flyout/risk_summary");
var _flyout_body = require("../../shared/components/flyout_body");
var _observed_entity = require("../shared/components/observed_entity");
var _ = require(".");
var _use_observed_host_fields = require("./hooks/use_observed_host_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HostPanelContent = ({
  hostName,
  observedHost,
  riskScoreState,
  contextID,
  scopeId,
  isDraggable,
  openDetailsPanel
}) => {
  var _riskScoreState$data;
  const observedFields = (0, _use_observed_host_fields.useObservedHostFields)(observedHost);
  return /*#__PURE__*/_react.default.createElement(_flyout_body.FlyoutBody, null, riskScoreState.isModuleEnabled && ((_riskScoreState$data = riskScoreState.data) === null || _riskScoreState$data === void 0 ? void 0 : _riskScoreState$data.length) !== 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_risk_summary.RiskSummary, {
    riskScoreData: riskScoreState,
    queryId: _.HOST_PANEL_RISK_SCORE_QUERY_ID,
    openDetailsPanel: openDetailsPanel
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null)), /*#__PURE__*/_react.default.createElement(_asset_criticality_selector.AssetCriticalityAccordion, {
    entity: {
      name: hostName,
      type: 'host'
    }
  }), /*#__PURE__*/_react.default.createElement(_observed_entity.ObservedEntity, {
    observedData: observedHost,
    contextID: contextID,
    scopeId: scopeId,
    isDraggable: isDraggable,
    observedFields: observedFields,
    queryId: _.HOST_PANEL_OBSERVED_HOST_QUERY_ID
  }));
};
exports.HostPanelContent = HostPanelContent;