"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsTimelineFlyoutOpen = void 0;
var _use_url_state = require("../../../../common/hooks/use_url_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook that returns which flyout is the user currently interacting with.
 * If the url contains timelineFlyout parameter and its value is not empty, we know the timeline flyout is rendered.
 * As it is always on top of the normal flyout, we can deduce which flyout the user is interacting with.
 */
const useIsTimelineFlyoutOpen = () => {
  const query = new URLSearchParams(window.location.search);
  return query.has(_use_url_state.URL_PARAM_KEY.timelineFlyout) && query.get(_use_url_state.URL_PARAM_KEY.timelineFlyout) !== '()';
};
exports.useIsTimelineFlyoutOpen = useIsTimelineFlyoutOpen;