"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutTour = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _tour_step_config = require("../utils/tour_step_config");
var _constants = require("../../../../../common/constants");
var _kibana = require("../../../../common/lib/kibana");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * This timeline tour only valid for 8.12 release is not needed for 8.13
 *
 * */

const MAX_POPOVER_WIDTH = 500;
const TOUR_SUBTITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.tour.subtitle', {
  defaultMessage: 'A redesigned alert experience'
});

/**
 * Shared component that generates tour steps based on supplied tour step content.
 * Supports tours being shown in different panels and manages state via local storage
 */
const FlyoutTour = ({
  tourStepContent,
  totalSteps,
  goToOverviewTab,
  goToLeftPanel
}) => {
  const {
    services: {
      storage
    }
  } = (0, _kibana.useKibana)();
  const [tourState, setTourState] = (0, _react.useState)(() => {
    const restoredTourState = storage.get(_constants.NEW_FEATURES_TOUR_STORAGE_KEYS.FLYOUT);
    if (restoredTourState != null) {
      return restoredTourState;
    }
    return _tour_step_config.tourConfig;
  });
  (0, _react.useEffect)(() => {
    storage.set(_constants.NEW_FEATURES_TOUR_STORAGE_KEYS.FLYOUT, tourState);
    if (tourState.isTourActive && tourState.currentTourStep === 1 && goToOverviewTab) {
      goToOverviewTab();
    }
  }, [storage, tourState, goToOverviewTab]);
  const nextStep = (0, _react.useCallback)(() => {
    setTourState(prev => {
      if (prev.currentTourStep === 3 && goToLeftPanel) {
        goToLeftPanel();
      }
      return {
        ...prev,
        currentTourStep: prev.currentTourStep + 1
      };
    });
  }, [goToLeftPanel]);
  const finishTour = (0, _react.useCallback)(() => {
    setTourState(prev => {
      return {
        ...prev,
        isTourActive: false
      };
    });
  }, []);
  const getFooterAction = (0, _react.useCallback)(step => {
    // if it's the last step, we don't want to show the next button
    return step === totalSteps ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "success",
      size: "s",
      onClick: finishTour
    }, _i18n.i18n.translate('xpack.securitySolution.flyout.tour.finish.text', {
      defaultMessage: 'Finish'
    })) : [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      color: "text",
      onClick: finishTour
    }, _i18n.i18n.translate('xpack.securitySolution.flyout.tour.exit.text', {
      defaultMessage: 'Exit'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "success",
      size: "s",
      onClick: nextStep
    }, _i18n.i18n.translate('xpack.securitySolution.flyout.tour.Next.text', {
      defaultMessage: 'Next'
    }))];
  }, [finishTour, nextStep, totalSteps]);

  // Do not show tour if it is inactive
  if (!tourState.isTourActive) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, tourStepContent.map(steps => {
    const stepCount = steps.stepNumber;
    if (tourState.currentTourStep !== stepCount) return null;
    const panelProps = {
      'data-test-subj': `${_test_ids.FLYOUT_TOUR_TEST_ID}-${stepCount}`
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
      panelProps: panelProps,
      key: stepCount,
      step: stepCount,
      isStepOpen: tourState.isTourActive,
      maxWidth: MAX_POPOVER_WIDTH,
      stepsTotal: totalSteps,
      onFinish: finishTour,
      title: steps.title,
      content: steps.content,
      anchor: `[data-test-subj=${steps.anchor}]`,
      anchorPosition: steps.anchorPosition,
      footerAction: getFooterAction(stepCount),
      subtitle: TOUR_SUBTITLE
    });
  }));
};
exports.FlyoutTour = FlyoutTour;
FlyoutTour.displayName = 'FlyoutTour';