"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isEcsAllowedValue = exports.getEcsAllowedValueDescription = exports.EVENT_CATEGORY_TO_FIELD = void 0;
var _ecs = require("@elastic/ecs");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Helper function to return if the value is in the allowed value list of an ecs field
 * @param fieldName
 * @param value
 * @returns boolean if value is an allowed value
 */
const isEcsAllowedValue = (fieldName, value) => {
  var _EcsFlat$fieldName$al, _EcsFlat$fieldName;
  if (!value || value == null) {
    return false;
  }
  const allowedValues = (_EcsFlat$fieldName$al = (_EcsFlat$fieldName = _ecs.EcsFlat[fieldName]) === null || _EcsFlat$fieldName === void 0 ? void 0 : _EcsFlat$fieldName.allowed_values) !== null && _EcsFlat$fieldName$al !== void 0 ? _EcsFlat$fieldName$al : [];
  return Boolean(allowedValues === null || allowedValues === void 0 ? void 0 : allowedValues.find(item => item.name === value));
};

/**
 * Helper function to return the description of an allowed value of the specified field
 * @param fieldName
 * @param value
 * @returns ecs description of the value
 */
exports.isEcsAllowedValue = isEcsAllowedValue;
const getEcsAllowedValueDescription = (fieldName, value) => {
  var _EcsFlat$fieldName$al2, _EcsFlat$fieldName2, _allowedValues$find$d, _allowedValues$find;
  const allowedValues = (_EcsFlat$fieldName$al2 = (_EcsFlat$fieldName2 = _ecs.EcsFlat[fieldName]) === null || _EcsFlat$fieldName2 === void 0 ? void 0 : _EcsFlat$fieldName2.allowed_values) !== null && _EcsFlat$fieldName$al2 !== void 0 ? _EcsFlat$fieldName$al2 : [];
  return (_allowedValues$find$d = allowedValues === null || allowedValues === void 0 ? void 0 : (_allowedValues$find = allowedValues.find(item => item.name === value)) === null || _allowedValues$find === void 0 ? void 0 : _allowedValues$find.description) !== null && _allowedValues$find$d !== void 0 ? _allowedValues$find$d : _i18n.i18n.translate('xpack.securitySolution.flyout.right.about.noEventKindDescriptionMessage', {
    defaultMessage: "This field doesn't have a description because it's not part of ECS."
  });
};

// mapping of event category to the field displayed as title
exports.getEcsAllowedValueDescription = getEcsAllowedValueDescription;
const EVENT_CATEGORY_TO_FIELD = exports.EVENT_CATEGORY_TO_FIELD = {
  authentication: 'user.name',
  configuration: '',
  database: '',
  driver: '',
  email: '',
  file: 'file.name',
  host: 'host.name',
  iam: '',
  intrusion_detection: '',
  malware: '',
  network: '',
  package: '',
  process: 'process.name',
  registry: '',
  session: '',
  threat: '',
  vulnerability: '',
  web: ''
};