"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSessionPreview = void 0;
var _utils = require("../../shared/utils");
var _helpers = require("../../../../timelines/components/side_panel/event_details/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook that returns the session view configuration if the session view is available for the alert
 */
const useSessionPreview = ({
  getFieldsData,
  dataFormattedForFieldBrowser
}) => {
  const {
    indexName: _index,
    alertId: _id
  } = (0, _helpers.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const index = (0, _utils.getField)(getFieldsData('kibana.alert.ancestors.index')) || _index;
  const entryLeaderEntityId = (0, _utils.getField)(getFieldsData('process.entry_leader.entity_id'));
  const entryLeaderStart = (0, _utils.getField)(getFieldsData('process.entry_leader.start'));
  const entityId = (0, _utils.getField)(getFieldsData('process.entity_id'));
  const time = (0, _utils.getField)(getFieldsData('kibana.alert.original_time')) || (0, _utils.getField)(getFieldsData('timestamp'));
  if (!index || !entryLeaderEntityId || !entryLeaderStart) {
    return null;
  }
  return {
    index,
    sessionEntityId: entryLeaderEntityId,
    sessionStartTime: entryLeaderStart,
    ...(entityId && {
      jumpToEntityId: entityId
    }),
    ...(time && {
      jumpToCursor: time
    }),
    ...(_id && {
      investigatedAlertId: _id
    })
  };
};
exports.useSessionPreview = useSessionPreview;