"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelHeader = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _flyout_header = require("../../shared/components/flyout_header");
var _flyout_header_tabs = require("../../shared/components/flyout_header_tabs");
var _alert_header_title = require("./components/alert_header_title");
var _event_header_title = require("./components/event_header_title");
var _context = require("./context");
var _helpers = require("../../../timelines/components/side_panel/event_details/helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PanelHeader = exports.PanelHeader = /*#__PURE__*/(0, _react.memo)(({
  selectedTabId,
  setSelectedTabId,
  tabs
}) => {
  const {
    dataFormattedForFieldBrowser
  } = (0, _context.useRightPanelContext)();
  const {
    isAlert
  } = (0, _helpers.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const onSelectedTabChanged = id => setSelectedTabId(id);
  const renderTabs = tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => onSelectedTabChanged(tab.id),
    isSelected: tab.id === selectedTabId,
    key: index,
    "data-test-subj": tab['data-test-subj']
  }, tab.name));
  return /*#__PURE__*/_react.default.createElement(_flyout_header.FlyoutHeader, null, isAlert ? /*#__PURE__*/_react.default.createElement(_alert_header_title.AlertHeaderTitle, null) : /*#__PURE__*/_react.default.createElement(_event_header_title.EventHeaderTitle, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_flyout_header_tabs.FlyoutHeaderTabs, null, renderTabs));
});
PanelHeader.displayName = 'PanelHeader';