"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelFooter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _uiTheme = require("@kbn/ui-theme");
var _panel_keys = require("../shared/constants/panel_keys");
var _flyout = require("../../../timelines/components/side_panel/event_details/flyout");
var _context = require("./context");
var _use_host_isolation_tools = require("../../../timelines/components/side_panel/event_details/use_host_isolation_tools");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ContainerDiv = (0, _styledComponents.default)('div')`
  .side-panel-flyout-footer {
    padding: ${_uiTheme.euiThemeVars.euiPanelPaddingModifiers.paddingMedium};
  }
`;
/**
 *
 */
const PanelFooter = ({
  isPreview
}) => {
  const {
    closeFlyout,
    openRightPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    eventId,
    indexName,
    dataFormattedForFieldBrowser,
    dataAsNestedObject,
    refetchFlyoutData,
    scopeId
  } = (0, _context.useRightPanelContext)();
  const {
    isHostIsolationPanelOpen,
    showHostIsolationPanel
  } = (0, _use_host_isolation_tools.useHostIsolationTools)();
  const showHostIsolationPanelCallback = (0, _react.useCallback)(action => {
    showHostIsolationPanel(action);
    openRightPanel({
      id: _panel_keys.DocumentDetailsIsolateHostPanelKey,
      params: {
        id: eventId,
        indexName,
        scopeId,
        isolateAction: action
      }
    });
  }, [eventId, indexName, openRightPanel, scopeId, showHostIsolationPanel]);
  return !isPreview ? /*#__PURE__*/_react.default.createElement(ContainerDiv, null, /*#__PURE__*/_react.default.createElement(_flyout.FlyoutFooter, {
    detailsData: dataFormattedForFieldBrowser,
    detailsEcsData: dataAsNestedObject,
    handleOnEventClosed: closeFlyout,
    isHostIsolationPanelOpen: isHostIsolationPanelOpen,
    isReadOnly: false,
    loadingEventDetails: false,
    onAddIsolationStatusClick: showHostIsolationPanelCallback,
    scopeId: scopeId,
    refetchFlyoutData: refetchFlyoutData
  })) : null;
};
exports.PanelFooter = PanelFooter;