"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RightPanelTour = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _context = require("../context");
var _flyout_tour = require("../../shared/components/flyout_tour");
var _tour_step_config = require("../../shared/utils/tour_step_config");
var _utils = require("../../shared/utils");
var _panel_keys = require("../../shared/constants/panel_keys");
var _event_kinds = require("../../shared/constants/event_kinds");
var _use_is_timeline_flyout_open = require("../../shared/hooks/use_is_timeline_flyout_open");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Guided tour for the right panel in details flyout
 */
const RightPanelTour = exports.RightPanelTour = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    openLeftPanel,
    openRightPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    eventId,
    indexName,
    scopeId,
    isPreview,
    getFieldsData
  } = (0, _context.useRightPanelContext)();
  const eventKind = (0, _utils.getField)(getFieldsData('event.kind'));
  const isAlert = eventKind === _event_kinds.EventKind.signal;
  const isTimelineFlyoutOpen = (0, _use_is_timeline_flyout_open.useIsTimelineFlyoutOpen)();
  const showTour = isAlert && !isPreview && !isTimelineFlyoutOpen;
  const goToLeftPanel = (0, _react.useCallback)(() => {
    openLeftPanel({
      id: _panel_keys.DocumentDetailsLeftPanelKey,
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
  }, [eventId, indexName, scopeId, openLeftPanel]);
  const goToOverviewTab = (0, _react.useCallback)(() => {
    openRightPanel({
      id: _panel_keys.DocumentDetailsRightPanelKey,
      path: {
        tab: 'overview'
      },
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
  }, [eventId, indexName, scopeId, openRightPanel]);
  const tourStepContent = (0, _react.useMemo)(
  // we append the left tour steps here to support the scenarios where the flyout left section is already expanded when starting the tour
  () => [...(0, _tour_step_config.getRightSectionTourSteps)(), ...(0, _tour_step_config.getLeftSectionTourSteps)()], []);
  return showTour ? /*#__PURE__*/_react.default.createElement(_flyout_tour.FlyoutTour, {
    tourStepContent: tourStepContent,
    totalSteps: 5,
    goToOverviewTab: goToOverviewTab,
    goToLeftPanel: goToLeftPanel
  }) : null;
});
RightPanelTour.displayName = 'RightPanelTour';