"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentStatus = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _i18nReact = require("@kbn/i18n-react");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _eui = require("@elastic/eui");
var _empty_value = require("../../../../common/components/empty_value");
var _constants = require("../../../../timelines/components/timeline/body/renderers/constants");
var _status_popover_button = require("../../../../common/components/event_details/overview/status_popover_button");
var _context = require("../context");
var _helpers = require("../../../../common/components/event_details/helpers");
var _cell_actions = require("./cell_actions");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Checks if the field info has data to convert EnrichedFieldInfo into EnrichedFieldInfoWithValues
 */
function hasData(fieldInfo) {
  return !!fieldInfo && Array.isArray(fieldInfo.values);
}

/**
 * Document details status displayed in flyout right section header
 */
const DocumentStatus = () => {
  const {
    closeFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    eventId,
    browserFields,
    dataFormattedForFieldBrowser,
    scopeId,
    isPreview
  } = (0, _context.useRightPanelContext)();
  const statusData = (0, _react.useMemo)(() => {
    const item = (0, _fp.find)({
      field: _constants.SIGNAL_STATUS_FIELD_NAME,
      category: 'kibana'
    }, dataFormattedForFieldBrowser);
    return item && (0, _helpers.getEnrichedFieldInfo)({
      eventId,
      contextId: scopeId,
      scopeId,
      browserFields,
      item
    });
  }, [browserFields, dataFormattedForFieldBrowser, eventId, scopeId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    "data-test-subj": _test_ids.STATUS_TITLE_TEST_ID
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.header.statusTitle",
    defaultMessage: "Status"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, !statusData || !hasData(statusData) || isPreview ? (0, _empty_value.getEmptyTagValue)() : /*#__PURE__*/_react.default.createElement(_cell_actions.CellActions, {
    field: _constants.SIGNAL_STATUS_FIELD_NAME,
    value: statusData.values[0]
  }, /*#__PURE__*/_react.default.createElement(_status_popover_button.StatusPopoverButton, {
    eventId: eventId,
    contextId: scopeId,
    enrichedFieldInfo: statusData,
    scopeId: scopeId,
    handleOnEventClosed: closeFlyout
  }))));
};
exports.DocumentStatus = DocumentStatus;
DocumentStatus.displayName = 'DocumentStatus';