"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelatedAlertsBySession = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_fetch_related_alerts_by_session = require("../../shared/hooks/use_fetch_related_alerts_by_session");
var _insights_summary_row = require("./insights_summary_row");
var _test_ids = require("./test_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ICON = 'warning';
/**
 * Show related alerts by session in summary row
 */
const RelatedAlertsBySession = ({
  entityId,
  scopeId
}) => {
  const {
    loading,
    error,
    dataCount
  } = (0, _use_fetch_related_alerts_by_session.useFetchRelatedAlertsBySession)({
    entityId,
    scopeId
  });
  const text = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.insights.correlations.sessionAlertsLabel",
    defaultMessage: "{count, plural, one {alert} other {alerts}} related by session",
    values: {
      count: dataCount
    }
  });
  return /*#__PURE__*/_react.default.createElement(_insights_summary_row.InsightsSummaryRow, {
    loading: loading,
    error: error,
    icon: ICON,
    value: dataCount,
    text: text,
    "data-test-subj": _test_ids.CORRELATIONS_RELATED_ALERTS_BY_SESSION_TEST_ID,
    key: `correlation-row-${text}`
  });
};
exports.RelatedAlertsBySession = RelatedAlertsBySession;
RelatedAlertsBySession.displayName = 'RelatedAlertsBySession';