"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelatedAlertsBySameSourceEvent = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_fetch_related_alerts_by_same_source_event = require("../../shared/hooks/use_fetch_related_alerts_by_same_source_event");
var _insights_summary_row = require("./insights_summary_row");
var _test_ids = require("./test_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ICON = 'warning';
/**
 * Show related alerts by same source event in summary row
 */
const RelatedAlertsBySameSourceEvent = ({
  originalEventId,
  scopeId
}) => {
  const {
    loading,
    dataCount
  } = (0, _use_fetch_related_alerts_by_same_source_event.useFetchRelatedAlertsBySameSourceEvent)({
    originalEventId,
    scopeId
  });
  const text = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.insights.correlations.sourceAlertsLabel",
    defaultMessage: "{count, plural, one {alert} other {alerts}} related by source event",
    values: {
      count: dataCount
    }
  });
  return /*#__PURE__*/_react.default.createElement(_insights_summary_row.InsightsSummaryRow, {
    loading: loading,
    icon: ICON,
    value: dataCount,
    text: text,
    "data-test-subj": _test_ids.CORRELATIONS_RELATED_ALERTS_BY_SAME_SOURCE_EVENT_TEST_ID,
    key: `correlation-row-${text}`
  });
};
exports.RelatedAlertsBySameSourceEvent = RelatedAlertsBySameSourceEvent;
RelatedAlertsBySameSourceEvent.displayName = 'RelatedAlertsBySameSourceEvent';