"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Reason = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../common/lib/kibana");
var _utils = require("../../shared/utils");
var _panel_keys = require("../../shared/constants/panel_keys");
var _preview = require("../../preview");
var _test_ids = require("./test_ids");
var _helpers = require("../../../../timelines/components/side_panel/event_details/helpers");
var _context = require("../context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Displays the information provided by the rowRenderer. Supports multiple types of documents.
 */
const Reason = () => {
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    eventId,
    indexName,
    scopeId,
    dataFormattedForFieldBrowser,
    getFieldsData
  } = (0, _context.useRightPanelContext)();
  const {
    isAlert
  } = (0, _helpers.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const alertReason = (0, _utils.getField)(getFieldsData(_ruleDataUtils.ALERT_REASON));
  const {
    openPreviewPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const openRulePreview = (0, _react.useCallback)(() => {
    openPreviewPanel({
      id: _panel_keys.DocumentDetailsPreviewPanelKey,
      path: {
        tab: _preview.AlertReasonPreviewPanel
      },
      params: {
        id: eventId,
        indexName,
        scopeId,
        banner: {
          title: _i18n.i18n.translate('xpack.securitySolution.flyout.right.about.reason.alertReasonPreviewTitle', {
            defaultMessage: 'Preview alert reason'
          }),
          backgroundColor: 'warning',
          textColor: 'warning'
        }
      }
    });
    telemetry.reportDetailsFlyoutOpened({
      location: scopeId,
      panel: 'preview'
    });
  }, [eventId, openPreviewPanel, indexName, scopeId, telemetry]);
  const viewPreview = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "expand",
    onClick: openRulePreview,
    iconSide: "right",
    "data-test-subj": _test_ids.REASON_DETAILS_PREVIEW_BUTTON_TEST_ID,
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.about.reason.alertReasonButtonAriaLabel', {
      defaultMessage: 'Show full reason'
    }),
    disabled: !alertReason
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.about.reason.alertReasonButtonLabel",
    defaultMessage: "Show full reason"
  }))), [alertReason, openRulePreview]);
  const alertReasonText = alertReason ? alertReason : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.about.reason.noReasonDescription",
    defaultMessage: "There's no source event information for this alert."
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.REASON_TITLE_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, isAlert ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.about.reason.alertReasonTitle",
    defaultMessage: "Alert reason"
  }))), viewPreview) : /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.about.reason.documentReasonTitle",
    defaultMessage: "Document reason"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.REASON_DETAILS_TEST_ID
  }, isAlert ? alertReasonText : '-'));
};
exports.Reason = Reason;
Reason.displayName = 'Reason';