"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrevalenceOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _i18nReact = require("@kbn/i18n-react");
var _expandable_panel = require("../../../shared/components/expandable_panel");
var _use_prevalence = require("../../shared/hooks/use_prevalence");
var _test_ids = require("./test_ids");
var _context = require("../context");
var _panel_keys = require("../../shared/constants/panel_keys");
var _left = require("../../left");
var _prevalence_details = require("../../left/components/prevalence_details");
var _insights_summary_row = require("./insights_summary_row");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PERCENTAGE_THRESHOLD = 0.1; // we show the prevalence if its value is below 10%
const DEFAULT_FROM = 'now-30d';
const DEFAULT_TO = 'now';

/**
 * Prevalence section under Insights section, overview tab.
 * The component fetches the necessary data at once. The loading and error states are handled by the ExpandablePanel component.
 */
const PrevalenceOverview = () => {
  const {
    eventId,
    indexName,
    dataFormattedForFieldBrowser,
    scopeId,
    investigationFields
  } = (0, _context.useRightPanelContext)();
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const goPrevalenceTab = (0, _react.useCallback)(() => {
    openLeftPanel({
      id: _panel_keys.DocumentDetailsLeftPanelKey,
      path: {
        tab: _left.LeftPanelInsightsTab,
        subTab: _prevalence_details.PREVALENCE_TAB_ID
      },
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
  }, [eventId, openLeftPanel, indexName, scopeId]);
  const {
    loading,
    error,
    data
  } = (0, _use_prevalence.usePrevalence)({
    dataFormattedForFieldBrowser,
    investigationFields,
    interval: {
      from: DEFAULT_FROM,
      to: DEFAULT_TO
    }
  });

  // only show data if the host prevalence is below 10%
  const uncommonData = (0, _react.useMemo)(() => data.filter(d => isFinite(d.hostPrevalence) && d.hostPrevalence > 0 && d.hostPrevalence < PERCENTAGE_THRESHOLD), [data]);
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.insights.prevalence.prevalenceTitle",
        defaultMessage: "Prevalence"
      }),
      link: {
        callback: goPrevalenceTab,
        tooltip: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.flyout.right.insights.prevalence.prevalenceTooltip",
          defaultMessage: "Show all prevalence"
        })
      },
      iconType: 'arrowStart'
    },
    content: {
      loading,
      error
    },
    "data-test-subj": _test_ids.PREVALENCE_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, uncommonData.length > 0 ? uncommonData.map(d => /*#__PURE__*/_react.default.createElement(_insights_summary_row.InsightsSummaryRow, {
    icon: 'warning',
    text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.insights.prevalence.rowDescription",
      defaultMessage: "{field}, {value} is uncommon",
      values: {
        field: d.field,
        value: d.values.toString()
      }
    }),
    "data-test-subj": `${_test_ids.PREVALENCE_TEST_ID}${d.field}`,
    key: `${_test_ids.PREVALENCE_TEST_ID}${d.field}`
  })) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.insights.prevalence.noDataDescription",
    defaultMessage: "No prevalence data available."
  })));
};
exports.PrevalenceOverview = PrevalenceOverview;
PrevalenceOverview.displayName = 'PrevalenceOverview';