"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationGuide = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_investigation_guide = require("../../shared/hooks/use_investigation_guide");
var _context = require("../context");
var _panel_keys = require("../../shared/constants/panel_keys");
var _left = require("../../left");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Render either the investigation guide button that opens Investigation section in the left panel,
 * or a no-data message if investigation guide hasn't been set up on the rule
 */
const InvestigationGuide = () => {
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    eventId,
    indexName,
    scopeId,
    dataFormattedForFieldBrowser,
    isPreview
  } = (0, _context.useRightPanelContext)();
  const {
    loading,
    error,
    basicAlertData,
    ruleNote
  } = (0, _use_investigation_guide.useInvestigationGuide)({
    dataFormattedForFieldBrowser
  });
  const goToInvestigationsTab = (0, _react.useCallback)(() => {
    openLeftPanel({
      id: _panel_keys.DocumentDetailsLeftPanelKey,
      path: {
        tab: _left.LeftPanelInvestigationTab
      },
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
  }, [eventId, indexName, openLeftPanel, scopeId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": _test_ids.INVESTIGATION_GUIDE_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.investigation.investigationGuide.investigationGuideTitle",
    defaultMessage: "Investigation guide"
  })))), isPreview ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.investigation.investigationGuide.previewMessage",
    defaultMessage: "Investigation guide is not available in alert preview."
  }) : loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": _test_ids.INVESTIGATION_GUIDE_LOADING_TEST_ID,
    contentAriaLabel: _i18n.i18n.translate('xpack.securitySolution.flyout.right.investigation.investigationGuide.investigationGuideLoadingAriaLabel', {
      defaultMessage: 'investigation guide'
    })
  }) : !error && basicAlertData.ruleId && ruleNote ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: goToInvestigationsTab,
    iconType: "documentation",
    "data-test-subj": _test_ids.INVESTIGATION_GUIDE_BUTTON_TEST_ID,
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.investigation.investigationGuide.investigationGuideButtonAriaLabel', {
      defaultMessage: 'Show investigation guide'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.investigation.investigationGuide.investigationGuideButtonLabel",
    defaultMessage: "Show investigation guide"
  }))) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.investigation.investigationGuide.noDataDescription",
    defaultMessage: "There\u2019s no investigation guide for this rule."
  }));
};
exports.InvestigationGuide = InvestigationGuide;
InvestigationGuide.displayName = 'InvestigationGuideButton';