"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightedFieldsCell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _sentinel_one_agent_status = require("../../../../detections/components/host_isolation/sentinel_one_agent_status");
var _sentinelone_alert_check = require("../../../../common/utils/sentinelone_alert_check");
var _endpoint_agent_status = require("../../../../common/components/endpoint/endpoint_agent_status");
var _context = require("../context");
var _constants = require("../../../../timelines/components/timeline/body/renderers/constants");
var _panel_keys = require("../../shared/constants/panel_keys");
var _left = require("../../left");
var _entities_details = require("../../left/components/entities_details");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * // Currently we can use the same component for both host name and username
 */
const LinkFieldCell = ({
  value
}) => {
  const {
    scopeId,
    eventId,
    indexName
  } = (0, _context.useRightPanelContext)();
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const goToInsightsEntities = (0, _react.useCallback)(() => {
    openLeftPanel({
      id: _panel_keys.DocumentDetailsLeftPanelKey,
      path: {
        tab: _left.LeftPanelInsightsTab,
        subTab: _entities_details.ENTITIES_TAB_ID
      },
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
  }, [eventId, indexName, openLeftPanel, scopeId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: goToInsightsEntities,
    "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_LINKED_CELL_TEST_ID
  }, value);
};
/**
 * Renders a component in the highlighted fields table cell based on the field name
 */
const HighlightedFieldsCell = ({
  values,
  field,
  originalField
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, values != null && values.map((value, i) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: `${i}-${value}`,
    "data-test-subj": `${value}-${_test_ids.HIGHLIGHTED_FIELDS_CELL_TEST_ID}`
  }, field === _constants.HOST_NAME_FIELD_NAME || field === _constants.USER_NAME_FIELD_NAME ? /*#__PURE__*/_react.default.createElement(LinkFieldCell, {
    value: value
  }) : field === _constants.AGENT_STATUS_FIELD_NAME && originalField === _sentinelone_alert_check.SENTINEL_ONE_AGENT_ID_FIELD ? /*#__PURE__*/_react.default.createElement(_sentinel_one_agent_status.SentinelOneAgentStatus, {
    agentId: String(value !== null && value !== void 0 ? value : ''),
    "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_AGENT_STATUS_CELL_TEST_ID
  }) : field === _constants.AGENT_STATUS_FIELD_NAME ? /*#__PURE__*/_react.default.createElement(_endpoint_agent_status.EndpointAgentStatusById, {
    endpointAgentId: String(value !== null && value !== void 0 ? value : ''),
    "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_AGENT_STATUS_CELL_TEST_ID
  }) : /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_BASIC_CELL_TEST_ID
  }, value));
}));
exports.HighlightedFieldsCell = HighlightedFieldsCell;