"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CorrelationsOverview = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _i18nReact = require("@kbn/i18n-react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _expandable_panel = require("../../../shared/components/expandable_panel");
var _use_show_related_alerts_by_session = require("../../shared/hooks/use_show_related_alerts_by_session");
var _related_alerts_by_session = require("./related_alerts_by_session");
var _use_show_related_alerts_by_same_source_event = require("../../shared/hooks/use_show_related_alerts_by_same_source_event");
var _related_alerts_by_same_source_event = require("./related_alerts_by_same_source_event");
var _related_alerts_by_ancestry = require("./related_alerts_by_ancestry");
var _use_show_related_alerts_by_ancestry = require("../../shared/hooks/use_show_related_alerts_by_ancestry");
var _suppressed_alerts = require("./suppressed_alerts");
var _use_show_suppressed_alerts = require("../../shared/hooks/use_show_suppressed_alerts");
var _related_cases = require("./related_cases");
var _use_show_related_cases = require("../../shared/hooks/use_show_related_cases");
var _test_ids = require("./test_ids");
var _context = require("../context");
var _panel_keys = require("../../shared/constants/panel_keys");
var _left = require("../../left");
var _correlations_details = require("../../left/components/correlations_details");
var _use_timeline_data_filters = require("../../../../timelines/containers/use_timeline_data_filters");
var _helpers = require("../../../../helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Correlations section under Insights section, overview tab.
 * The component fetches the necessary data, then pass it down to the InsightsSubSection component for loading and error state,
 * and the SummaryPanel component for data rendering.
 */
const CorrelationsOverview = () => {
  var _get;
  const {
    dataAsNestedObject,
    eventId,
    indexName,
    getFieldsData,
    scopeId,
    isPreview
  } = (0, _context.useRightPanelContext)();
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    selectedPatterns
  } = (0, _use_timeline_data_filters.useTimelineDataFilters)((0, _helpers.isActiveTimeline)(scopeId));
  const goToCorrelationsTab = (0, _react.useCallback)(() => {
    openLeftPanel({
      id: _panel_keys.DocumentDetailsLeftPanelKey,
      path: {
        tab: _left.LeftPanelInsightsTab,
        subTab: _correlations_details.CORRELATIONS_TAB_ID
      },
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
  }, [eventId, openLeftPanel, indexName, scopeId]);
  const {
    show: showAlertsByAncestry,
    documentId
  } = (0, _use_show_related_alerts_by_ancestry.useShowRelatedAlertsByAncestry)({
    getFieldsData,
    dataAsNestedObject,
    eventId,
    isPreview
  });
  const {
    show: showSameSourceAlerts,
    originalEventId
  } = (0, _use_show_related_alerts_by_same_source_event.useShowRelatedAlertsBySameSourceEvent)({
    eventId,
    getFieldsData
  });
  const {
    show: showAlertsBySession,
    entityId
  } = (0, _use_show_related_alerts_by_session.useShowRelatedAlertsBySession)({
    getFieldsData
  });
  const showCases = (0, _use_show_related_cases.useShowRelatedCases)({
    getFieldsData
  });
  const {
    show: showSuppressedAlerts,
    alertSuppressionCount
  } = (0, _use_show_suppressed_alerts.useShowSuppressedAlerts)({
    getFieldsData
  });
  const canShowAtLeastOneInsight = showAlertsByAncestry || showSameSourceAlerts || showAlertsBySession || showCases || showSuppressedAlerts;
  const ruleType = (_get = (0, _lodash.get)(dataAsNestedObject, _ruleDataUtils.ALERT_RULE_TYPE)) === null || _get === void 0 ? void 0 : _get[0];
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.insights.correlations.overviewTitle",
        defaultMessage: "Correlations"
      }),
      link: {
        callback: goToCorrelationsTab,
        tooltip: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.flyout.right.insights.correlations.overviewTooltip",
          defaultMessage: "Show all correlations"
        })
      },
      iconType: 'arrowStart'
    },
    "data-test-subj": _test_ids.CORRELATIONS_TEST_ID
  }, canShowAtLeastOneInsight ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, showSuppressedAlerts && /*#__PURE__*/_react.default.createElement(_suppressed_alerts.SuppressedAlerts, {
    alertSuppressionCount: alertSuppressionCount,
    ruleType: ruleType
  }), showCases && /*#__PURE__*/_react.default.createElement(_related_cases.RelatedCases, {
    eventId: eventId
  }), showSameSourceAlerts && /*#__PURE__*/_react.default.createElement(_related_alerts_by_same_source_event.RelatedAlertsBySameSourceEvent, {
    originalEventId: originalEventId,
    scopeId: scopeId
  }), showAlertsBySession && entityId && /*#__PURE__*/_react.default.createElement(_related_alerts_by_session.RelatedAlertsBySession, {
    entityId: entityId,
    scopeId: scopeId
  }), showAlertsByAncestry && /*#__PURE__*/_react.default.createElement(_related_alerts_by_ancestry.RelatedAlertsByAncestry, {
    documentId: documentId,
    indices: selectedPatterns,
    scopeId: scopeId
  })) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.insights.correlations.noDataDescription",
    defaultMessage: "No correlations data available."
  }));
};
exports.CorrelationsOverview = CorrelationsOverview;
CorrelationsOverview.displayName = 'CorrelationsOverview';