"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CellActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _context = require("../context");
var _helpers = require("../../../../helpers");
var _constants = require("../../../../actions/constants");
var _cell_actions = require("../../../../common/components/cell_actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Security cell action wrapper for document details flyout
 */
const CellActions = ({
  field,
  value,
  isObjectArray,
  children
}) => {
  const {
    scopeId,
    isPreview
  } = (0, _context.useRightPanelContext)();
  const data = (0, _react.useMemo)(() => ({
    field,
    value
  }), [field, value]);
  const metadata = (0, _react.useMemo)(() => ({
    scopeId,
    isObjectArray
  }), [scopeId, isObjectArray]);
  const disabledActionTypes = (0, _react.useMemo)(() => isPreview ? [_constants.SecurityCellActionType.FILTER, _constants.SecurityCellActionType.TOGGLE_COLUMN] : [], [isPreview]);
  return /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
    data: data,
    mode: _cell_actions.CellActionsMode.HOVER_RIGHT,
    triggerId: _cell_actions.SecurityCellActionsTrigger.DETAILS_FLYOUT,
    visibleCellActions: 6,
    sourcererScopeId: (0, _helpers.getSourcererScopeId)(scopeId),
    metadata: metadata,
    disabledActionTypes: disabledActionTypes
  }, children);
};
exports.CellActions = CellActions;
CellActions.displayName = 'CellActions';