"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertHeaderTitle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _i18n = require("@kbn/i18n");
var _use_rule_details_link = require("../../shared/hooks/use_rule_details_link");
var _status = require("./status");
var _severity = require("./severity");
var _risk_score = require("./risk_score");
var _use_refetch_by_scope = require("../../../../timelines/components/side_panel/event_details/flyout/use_refetch_by_scope");
var _helpers = require("../../../../timelines/components/side_panel/event_details/helpers");
var _context = require("../context");
var _formatted_date = require("../../../../common/components/formatted_date");
var _test_ids = require("./test_ids");
var _assignees = require("./assignees");
var _flyout_title = require("../../../shared/components/flyout_title");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Alert details flyout right section header
 */
const AlertHeaderTitle = exports.AlertHeaderTitle = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    dataFormattedForFieldBrowser,
    eventId,
    scopeId,
    isPreview,
    refetchFlyoutData,
    getFieldsData
  } = (0, _context.useRightPanelContext)();
  const {
    isAlert,
    ruleName,
    timestamp,
    ruleId
  } = (0, _helpers.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const href = (0, _use_rule_details_link.useRuleDetailsLink)({
    ruleId: !isPreview ? ruleId : null
  });
  const ruleTitle = (0, _react.useMemo)(() => href ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: href,
    target: "_blank",
    external: false
  }, /*#__PURE__*/_react.default.createElement(_flyout_title.FlyoutTitle, {
    title: ruleName,
    iconType: 'warning',
    isLink: true,
    "data-test-subj": _test_ids.FLYOUT_ALERT_HEADER_TITLE_TEST_ID
  })) : /*#__PURE__*/_react.default.createElement(_flyout_title.FlyoutTitle, {
    title: ruleName,
    iconType: 'warning',
    "data-test-subj": _test_ids.FLYOUT_ALERT_HEADER_TITLE_TEST_ID
  }), [ruleName, href]);
  const {
    refetch
  } = (0, _use_refetch_by_scope.useRefetchByScope)({
    scopeId
  });
  const alertAssignees = (0, _react.useMemo)(() => {
    var _ref;
    return (_ref = getFieldsData(_ruleDataUtils.ALERT_WORKFLOW_ASSIGNEE_IDS)) !== null && _ref !== void 0 ? _ref : [];
  }, [getFieldsData]);
  const onAssigneesUpdated = (0, _react.useCallback)(() => {
    refetch();
    refetchFlyoutData();
  }, [refetch, refetchFlyoutData]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_severity.DocumentSeverity, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), timestamp && /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
    value: new Date(timestamp)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), isAlert && ruleName ? ruleTitle : /*#__PURE__*/_react.default.createElement(_flyout_title.FlyoutTitle, {
    title: _i18n.i18n.translate('xpack.securitySolution.flyout.right.header.headerTitle', {
      defaultMessage: 'Document details'
    }),
    iconType: 'warning',
    "data-test-subj": _test_ids.FLYOUT_ALERT_HEADER_TITLE_TEST_ID
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    css: (0, _css.css)`
          padding: ${euiTheme.size.m} ${euiTheme.size.s};
        `,
    "data-test-subj": _test_ids.ALERT_SUMMARY_PANEL_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _css.css)`
              border-right: ${euiTheme.border.thin};
            `
  }, /*#__PURE__*/_react.default.createElement(_status.DocumentStatus, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _css.css)`
              border-right: ${euiTheme.border.thin};
            `
  }, /*#__PURE__*/_react.default.createElement(_risk_score.RiskScore, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_assignees.Assignees, {
    eventId: eventId,
    assignedUserIds: alertAssignees,
    onAssigneesUpdated: onAssigneesUpdated,
    isPreview: isPreview
  })))));
});
AlertHeaderTitle.displayName = 'AlertHeaderTitle';