"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePreviewPanelContext = exports.PreviewPanelProvider = exports.PreviewPanelContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_event_details = require("../shared/hooks/use_event_details");
var _flyout_error = require("../../shared/components/flyout_error");
var _flyout_loading = require("../../shared/components/flyout_loading");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PreviewPanelContext = exports.PreviewPanelContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const PreviewPanelProvider = exports.PreviewPanelProvider = /*#__PURE__*/(0, _react.memo)(({
  id,
  indexName,
  scopeId,
  ruleId,
  children
}) => {
  const {
    dataAsNestedObject,
    indexPattern,
    loading
  } = (0, _use_event_details.useEventDetails)({
    eventId: id,
    indexName
  });
  const contextValue = (0, _react.useMemo)(() => id && indexName && scopeId && dataAsNestedObject ? {
    eventId: id,
    indexName,
    scopeId,
    ruleId: ruleId !== null && ruleId !== void 0 ? ruleId : '',
    indexPattern,
    dataAsNestedObject
  } : undefined, [id, indexName, scopeId, ruleId, indexPattern, dataAsNestedObject]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_flyout_loading.FlyoutLoading, null);
  }
  if (!contextValue) {
    return /*#__PURE__*/_react.default.createElement(_flyout_error.FlyoutError, null);
  }
  return /*#__PURE__*/_react.default.createElement(PreviewPanelContext.Provider, {
    value: contextValue
  }, children);
});
PreviewPanelProvider.displayName = 'PreviewPanelProvider';
const usePreviewPanelContext = () => {
  const contextValue = (0, _react.useContext)(PreviewPanelContext);
  if (!contextValue) {
    throw new Error('PreviewPanelContext can only be used within PreviewPanelContext provider');
  }
  return contextValue;
};
exports.usePreviewPanelContext = usePreviewPanelContext;