"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulePreviewFooter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _context = require("../context");
var _flyout_footer = require("../../../shared/components/flyout_footer");
var _test_ids = require("./test_ids");
var _use_rule_details_link = require("../../shared/hooks/use_rule_details_link");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Footer in rule preview panel
 */
const RulePreviewFooter = exports.RulePreviewFooter = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    ruleId
  } = (0, _context.usePreviewPanelContext)();
  const href = (0, _use_rule_details_link.useRuleDetailsLink)({
    ruleId
  });
  return href ? /*#__PURE__*/_react.default.createElement(_flyout_footer.FlyoutFooter, {
    "data-test-subj": _test_ids.RULE_PREVIEW_FOOTER_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: href,
    target: "_blank",
    "data-test-subj": _test_ids.RULE_PREVIEW_NAVIGATE_TO_RULE_TEST_ID
  }, _i18n.i18n.translate('xpack.securitySolution.flyout.preview.rule.viewDetailsLabel', {
    defaultMessage: 'Show rule details'
  }))))) : null;
});
RulePreviewFooter.displayName = 'RulePreviewFooter';