"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyzeGraph = exports.ANALYZE_GRAPH_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _context = require("../context");
var _test_ids = require("./test_ids");
var _view = require("../../../../resolver/view");
var _use_timeline_data_filters = require("../../../../timelines/containers/use_timeline_data_filters");
var _helpers = require("../../../../helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ANALYZE_GRAPH_ID = exports.ANALYZE_GRAPH_ID = 'analyze_graph';

/**
 * Analyzer graph view displayed in the document details expandable flyout left section under the Visualize tab
 */
const AnalyzeGraph = () => {
  const {
    eventId
  } = (0, _context.useLeftPanelContext)();
  const scopeId = 'flyout'; // Different scope Id to distinguish flyout and data table analyzers
  const {
    from,
    to,
    shouldUpdate,
    selectedPatterns
  } = (0, _use_timeline_data_filters.useTimelineDataFilters)((0, _helpers.isActiveTimeline)(scopeId));
  const filters = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);

  // TODO as part of https://github.com/elastic/security-team/issues/7032
  //  bring back no data message if needed

  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.ANALYZER_GRAPH_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_view.Resolver, {
    databaseDocumentID: eventId,
    resolverComponentInstanceID: scopeId,
    indices: selectedPatterns,
    shouldUpdate: shouldUpdate,
    filters: filters
  }));
};
exports.AnalyzeGraph = AnalyzeGraph;
AnalyzeGraph.displayName = 'AnalyzeGraph';