"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.makeUsersReducer = exports.getInitialUsersState = void 0;
var _typescriptFsaReducers = require("typescript-fsa-reducers");
var _fp = require("@kbn/safer-lodash-set/fp");
var _constants = require("../../../common/store/constants");
var _actions = require("./actions");
var _helpers = require("./helpers");
var _model = require("./model");
var _common = require("../../../../common/search_strategy/common");
var _search_strategy = require("../../../../common/search_strategy");
var _common2 = require("../../../../common/search_strategy/security_solution/users/common");
var _constants2 = require("./constants");
var _storage = require("./storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInitialUsersState = storage => {
  var _ref, _ref2;
  const userAssetTable = (0, _storage.getUserAssetTableFromStorage)(storage);
  return {
    page: {
      queries: {
        [_model.UsersTableType.allUsers]: {
          activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
          limit: _constants.DEFAULT_TABLE_LIMIT,
          sort: {
            field: _common2.UsersFields.lastSeen,
            direction: _common.Direction.desc
          }
        },
        [_model.UsersTableType.authentications]: {
          activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
          limit: _constants.DEFAULT_TABLE_LIMIT
        },
        [_model.UsersTableType.risk]: {
          activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
          limit: _constants.DEFAULT_TABLE_LIMIT,
          sort: {
            field: _search_strategy.RiskScoreFields.userRiskScore,
            direction: _common.Direction.desc
          },
          severitySelection: []
        },
        [_model.UsersTableType.anomalies]: {
          jobIdSelection: [],
          intervalSelection: 'auto'
        },
        [_model.UsersTableType.events]: {
          activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
          limit: _constants.DEFAULT_TABLE_LIMIT
        }
      }
    },
    details: {
      queries: {
        [_model.UsersTableType.anomalies]: {
          jobIdSelection: [],
          intervalSelection: 'auto'
        },
        [_model.UsersTableType.events]: {
          activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE,
          limit: _constants.DEFAULT_TABLE_LIMIT
        }
      }
    },
    flyout: {
      queries: {
        [_model.UserAssetTableType.assetEntra]: (_ref = userAssetTable && userAssetTable[_model.UserAssetTableType.assetEntra]) !== null && _ref !== void 0 ? _ref : {
          fields: _constants2.USER_ASSET_TABLE_DEFAULTS_FIELDS[_model.UserAssetTableType.assetEntra]
        },
        [_model.UserAssetTableType.assetOkta]: (_ref2 = userAssetTable && userAssetTable[_model.UserAssetTableType.assetOkta]) !== null && _ref2 !== void 0 ? _ref2 : {
          fields: _constants2.USER_ASSET_TABLE_DEFAULTS_FIELDS[_model.UserAssetTableType.assetOkta]
        }
      }
    }
  };
};
exports.getInitialUsersState = getInitialUsersState;
const makeUsersReducer = storage => (0, _typescriptFsaReducers.reducerWithInitialState)(getInitialUsersState(storage)).case(_actions.setUsersTablesActivePageToZero, state => ({
  ...state,
  page: {
    ...state.page,
    queries: (0, _helpers.setUsersPageQueriesActivePageToZero)(state)
  }
})).case(_actions.updateTableActivePage, (state, {
  activePage,
  tableType
}) => ({
  ...state,
  page: {
    ...state.page,
    queries: {
      ...state.page.queries,
      [tableType]: {
        ...state.page.queries[tableType],
        activePage
      }
    }
  }
})).case(_actions.updateTableLimit, (state, {
  limit,
  tableType
}) => ({
  ...state,
  page: {
    ...state.page,
    queries: {
      ...state.page.queries,
      [tableType]: {
        ...state.page.queries[tableType],
        limit
      }
    }
  }
})).case(_actions.updateTableSorting, (state, {
  sort,
  tableType
}) => ({
  ...state,
  page: {
    ...state.page,
    queries: {
      ...state.page.queries,
      [tableType]: {
        ...state.page.queries[tableType],
        sort,
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
      }
    }
  }
})).case(_actions.updateUserRiskScoreSeverityFilter, (state, {
  severitySelection
}) => ({
  ...state,
  page: {
    ...state.page,
    queries: {
      ...state.page.queries,
      [_model.UsersTableType.risk]: {
        ...state.page.queries[_model.UsersTableType.risk],
        severitySelection,
        activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
      }
    }
  }
})).case(_actions.updateUsersAnomaliesJobIdFilter, (state, {
  jobIds,
  usersType
}) => {
  if (usersType === 'page') {
    return (0, _fp.set)('page.queries.anomalies.jobIdSelection', jobIds, state);
  } else {
    return (0, _fp.set)('details.queries.anomalies.jobIdSelection', jobIds, state);
  }
}).case(_actions.updateUsersAnomaliesInterval, (state, {
  interval,
  usersType
}) => {
  if (usersType === 'page') {
    return (0, _fp.set)('page.queries.anomalies.intervalSelection', interval, state);
  } else {
    return (0, _fp.set)('details.queries.anomalies.intervalSelection', interval, state);
  }
}).case(_actions.addUserAssetTableField, (state, {
  fieldName,
  tableId
}) => ({
  ...state,
  flyout: {
    ...state.flyout,
    queries: (0, _helpers.addAssetTableField)({
      fieldName,
      tableId,
      tableById: state.flyout.queries
    })
  }
})).case(_actions.removeUserAssetTableField, (state, {
  fieldName,
  tableId
}) => ({
  ...state,
  flyout: {
    ...state.flyout,
    queries: (0, _helpers.removeAssetTableField)({
      tableId,
      fieldName,
      tableById: state.flyout.queries
    })
  }
})).build();
exports.makeUsersReducer = makeUsersReducer;