"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ID = exports.AuthenticationsQueryTabBody = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _authentications_user_table = require("../../../components/authentication/authentications_user_table");
var _helpers = require("../../../components/authentication/helpers");
var _matrix_histogram = require("../../../../common/components/matrix_histogram");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ID = exports.ID = 'usersAuthenticationsQuery';
const HISTOGRAM_QUERY_ID = 'usersAuthenticationsHistogramQuery';
const AuthenticationsQueryTabBody = ({
  endDate,
  filterQuery,
  indexNames,
  skip,
  setQuery,
  startDate,
  type,
  deleteQuery,
  userName
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_matrix_histogram.MatrixHistogram, (0, _extends2.default)({
    endDate: endDate,
    filterQuery: filterQuery,
    id: HISTOGRAM_QUERY_ID,
    setQuery: setQuery,
    startDate: startDate
  }, _helpers.histogramConfigs)), /*#__PURE__*/_react.default.createElement(_authentications_user_table.AuthenticationsUserTable, {
    endDate: endDate,
    filterQuery: filterQuery,
    indexNames: indexNames,
    setQuery: setQuery,
    deleteQuery: deleteQuery,
    startDate: startDate,
    type: type,
    skip: skip,
    userName: userName
  }));
};
exports.AuthenticationsQueryTabBody = AuthenticationsQueryTabBody;
AuthenticationsQueryTabBody.displayName = 'AllUsersQueryTabBody';