"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usersStatItems = exports.TotalUsersKpi = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _kpi = require("../../../../components/kpi");
var _kpi_total_users_metric = require("../../../../../common/components/visualization_actions/lens_attributes/users/kpi_total_users_metric");
var _kpi_total_users_area = require("../../../../../common/components/visualization_actions/lens_attributes/users/kpi_total_users_area");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const euiVisColorPalette = (0, _eui.euiPaletteColorBlind)();
const euiColorVis1 = euiVisColorPalette[1];
const usersStatItems = exports.usersStatItems = [{
  key: 'users',
  fields: [{
    key: 'users',
    color: euiColorVis1,
    icon: 'storage',
    lensAttributes: _kpi_total_users_metric.kpiTotalUsersMetricLensAttributes
  }],
  enableAreaChart: true,
  description: i18n.USERS,
  areaChartLensAttributes: _kpi_total_users_area.kpiTotalUsersAreaLensAttributes
}];
const ID = 'TotalUsersKpiQuery';
const TotalUsersKpiComponent = ({
  from,
  to
}) => {
  return /*#__PURE__*/_react.default.createElement(_kpi.KpiBaseComponent, {
    id: ID,
    statItems: usersStatItems,
    from: from,
    to: to
  });
};
const TotalUsersKpi = exports.TotalUsersKpi = /*#__PURE__*/_react.default.memo(TotalUsersKpiComponent);