"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.authenticationsStatItems = exports.UsersKpiAuthentications = void 0;
var _react = _interopRequireDefault(require("react"));
var _kpi_user_authentications_area = require("../../../../../common/components/visualization_actions/lens_attributes/users/kpi_user_authentications_area");
var _kpi_user_authentications_bar = require("../../../../../common/components/visualization_actions/lens_attributes/users/kpi_user_authentications_bar");
var _kpi_user_authentications_metric_success = require("../../../../../common/components/visualization_actions/lens_attributes/users/kpi_user_authentications_metric_success");
var _kpi_user_authentication_metric_failure = require("../../../../../common/components/visualization_actions/lens_attributes/users/kpi_user_authentication_metric_failure");
var _kpi = require("../../../../components/kpi");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ID = 'usersKpiAuthentications';
var ChartColors = /*#__PURE__*/function (ChartColors) {
  ChartColors["authenticationsSuccess"] = "#54B399";
  ChartColors["authenticationsFailure"] = "#E7664C";
  return ChartColors;
}(ChartColors || {});
const authenticationsStatItems = exports.authenticationsStatItems = [{
  key: 'authentication',
  fields: [{
    key: 'authenticationsSuccess',
    name: i18n.SUCCESS_CHART_LABEL,
    description: i18n.SUCCESS_UNIT_LABEL,
    color: ChartColors.authenticationsSuccess,
    icon: 'check',
    lensAttributes: _kpi_user_authentications_metric_success.kpiUserAuthenticationsMetricSuccessLensAttributes
  }, {
    key: 'authenticationsFailure',
    name: i18n.FAIL_CHART_LABEL,
    description: i18n.FAIL_UNIT_LABEL,
    color: ChartColors.authenticationsFailure,
    icon: 'cross',
    lensAttributes: _kpi_user_authentication_metric_failure.kpiUserAuthenticationsMetricFailureLensAttributes
  }],
  enableAreaChart: true,
  enableBarChart: true,
  description: i18n.USER_AUTHENTICATIONS,
  areaChartLensAttributes: _kpi_user_authentications_area.kpiUserAuthenticationsAreaLensAttributes,
  barChartLensAttributes: _kpi_user_authentications_bar.kpiUserAuthenticationsBarLensAttributes
}];
const UsersKpiAuthenticationsComponent = ({
  from,
  to
}) => {
  return /*#__PURE__*/_react.default.createElement(_kpi.KpiBaseComponent, {
    id: ID,
    statItems: authenticationsStatItems,
    from: from,
    to: to
  });
};
UsersKpiAuthenticationsComponent.displayName = 'UsersKpiAuthenticationsComponent';
const UsersKpiAuthentications = exports.UsersKpiAuthentications = /*#__PURE__*/_react.default.memo(UsersKpiAuthenticationsComponent);