"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Network = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _public = require("@kbn/timelines-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _constants = require("../../../common/store/inputs/constants");
var _types = require("../../../app/types");
var _embedded_map = require("../components/embeddables/embedded_map");
var _filters_global = require("../../../common/components/filters_global");
var _header_page = require("../../../common/components/header_page");
var _last_event_time = require("../../../common/components/last_event_time");
var _tab_navigation = require("../../../common/components/navigation/tab_navigation");
var _kpi_network = require("../components/kpi_network");
var _search_bar = require("../../../common/components/search_bar");
var _page_wrapper = require("../../../common/components/page_wrapper");
var _use_full_screen = require("../../../common/containers/use_full_screen");
var _use_global_time = require("../../../common/containers/use_global_time");
var _search_strategy = require("../../../../common/search_strategy");
var _kibana = require("../../../common/lib/kibana");
var _kuery = require("../../../common/lib/kuery");
var _store = require("../../../common/store");
var _spy_routes = require("../../../common/utils/route/spy_routes");
var _display = require("../../hosts/pages/display");
var _store2 = require("../store");
var _navigation = require("./navigation");
var i18n = _interopRequireWildcard(require("./translations"));
var _types2 = require("./navigation/types");
var _helpers = require("../../../timelines/components/timeline/helpers");
var _sourcerer = require("../../../common/containers/sourcerer");
var _use_selector = require("../../../common/hooks/use_selector");
var _use_invalid_filter_query = require("../../../common/hooks/use_invalid_filter_query");
var _utils = require("../../../common/components/visualization_actions/utils");
var _empty_prompt = require("../../../common/components/empty_prompt");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Need a 100% height here to account for the graph/analyze tool, which sets no explicit height parameters, but fills the available space.
 */
const StyledFullHeightContainer = _styledComponents.default.div`
  display: flex;
  flex-direction: column;
  flex: 1 1 auto;
`;
const ID = 'NetworkQueryId';
const NetworkComponent = /*#__PURE__*/_react.default.memo(({
  hasMlUserPermissions,
  capabilitiesFetched
}) => {
  const containerElement = (0, _react.useRef)(null);
  const getTable = (0, _react.useMemo)(() => _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector(), []);
  const graphEventId = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTable;
    return ((_getTable = getTable(state, _securitysolutionDataTable.TableId.networkPageEvents)) !== null && _getTable !== void 0 ? _getTable : _securitysolutionDataTable.tableDefaults).graphEventId;
  });
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const globalFilters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const {
    to,
    from,
    setQuery,
    isInitializing
  } = (0, _use_global_time.useGlobalTime)();
  const {
    globalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const kibana = (0, _kibana.useKibana)();
  const {
    tabName
  } = (0, _reactRouterDom.useParams)();
  const canUseMaps = kibana.services.application.capabilities.maps.show;
  const tabsFilters = (0, _react.useMemo)(() => {
    if (tabName === _types2.NetworkRouteType.events) {
      return [...globalFilters, ..._utils.sourceOrDestinationIpExistsFilter];
    }
    return globalFilters;
  }, [tabName, globalFilters]);
  const {
    indicesExist,
    indexPattern,
    selectedPatterns,
    sourcererDataView
  } = (0, _sourcerer.useSourcererDataView)();
  const onSkipFocusBeforeEventsTable = (0, _react.useCallback)(() => {
    var _containerElement$cur, _containerElement$cur2;
    (_containerElement$cur = containerElement.current) === null || _containerElement$cur === void 0 ? void 0 : (_containerElement$cur2 = _containerElement$cur.querySelector('.inspectButtonComponent:last-of-type')) === null || _containerElement$cur2 === void 0 ? void 0 : _containerElement$cur2.focus();
  }, [containerElement]);
  const onSkipFocusAfterEventsTable = (0, _react.useCallback)(() => {
    (0, _helpers.resetKeyboardFocus)();
  }, []);
  const onKeyDown = (0, _react.useCallback)(keyboardEvent => {
    if ((0, _public.isTab)(keyboardEvent)) {
      (0, _helpers.onTimelineTabKeyPressed)({
        containerElement: containerElement.current,
        keyboardEvent,
        onSkipFocusBeforeEventsTable,
        onSkipFocusAfterEventsTable
      });
    }
  }, [containerElement, onSkipFocusBeforeEventsTable, onSkipFocusAfterEventsTable]);
  const [filterQuery, kqlError] = (0, _kuery.convertToBuildEsQuery)({
    config: (0, _common.getEsQueryConfig)(kibana.services.uiSettings),
    indexPattern,
    queries: [query],
    filters: globalFilters
  });
  const [tabsFilterQuery] = (0, _kuery.convertToBuildEsQuery)({
    config: (0, _common.getEsQueryConfig)(kibana.services.uiSettings),
    indexPattern,
    queries: [query],
    filters: tabsFilters
  });
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: ID,
    filterQuery,
    kqlError,
    query,
    startDate: from,
    endDate: to
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicesExist ? /*#__PURE__*/_react.default.createElement(StyledFullHeightContainer, {
    onKeyDown: onKeyDown,
    ref: containerElement
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "resize",
    handler: _fp.noop
  }), /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, {
    show: (0, _helpers.showGlobalFilters)({
      globalFullScreen,
      graphEventId
    })
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    sourcererDataView: sourcererDataView,
    id: _constants.InputsModelId.global
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    noPadding: globalFullScreen
  }, /*#__PURE__*/_react.default.createElement(_display.Display, {
    show: !globalFullScreen
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    subtitle: /*#__PURE__*/_react.default.createElement(_last_event_time.LastEventTime, {
      indexKey: _search_strategy.LastEventIndexKey.network,
      indexNames: selectedPatterns
    }),
    title: i18n.PAGE_TITLE,
    border: true
  }), canUseMaps && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "none",
    "data-test-subj": "conditional-embeddable-map"
  }, /*#__PURE__*/_react.default.createElement(_embedded_map.EmbeddedMap, {
    query: query,
    filters: globalFilters,
    startDate: from,
    endDate: to,
    setQuery: setQuery
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_kpi_network.NetworkKpiComponent, {
    from: from,
    to: to
  })), capabilitiesFetched && !isInitializing ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_display.Display, {
    show: !globalFullScreen
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_tab_navigation.TabNavigation, {
    navTabs: (0, _navigation.navTabsNetwork)(hasMlUserPermissions)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_navigation.NetworkRoutes, {
    filterQuery: tabsFilterQuery,
    from: from,
    isInitializing: isInitializing,
    indexPattern: indexPattern,
    indexNames: selectedPatterns,
    setQuery: setQuery,
    type: _store2.networkModel.NetworkType.page,
    to: to
  })) : /*#__PURE__*/_react.default.createElement(_navigation.NetworkRoutesLoading, null))) : /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.network
  }));
});
NetworkComponent.displayName = 'NetworkComponent';
const Network = exports.Network = /*#__PURE__*/_react.default.memo(NetworkComponent);