"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LineToolTipContentComponent = exports.LineToolTipContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _source_destination_arrows = require("../../source_destination/source_destination_arrows");
var _map_config = require("../map_config");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlowBadge = (0, _styledComponents.default)(_eui.EuiBadge)`
  height: 45px;
  min-width: 85px;
`;
const EuiFlexGroupStyled = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin: 0 auto;
`;
const LineToolTipContentComponent = ({
  contextId,
  featureProps
}) => {
  const lineProps = featureProps.reduce((acc, f) => {
    var _f$getRawValue;
    const rawValue = (_f$getRawValue = f.getRawValue()) !== null && _f$getRawValue !== void 0 ? _f$getRawValue : [];
    return {
      ...acc,
      ...{
        [f.getPropertyKey()]: Array.isArray(rawValue) ? rawValue : [rawValue]
      }
    };
  }, {});
  const isSrcDest = Object.keys(lineProps).includes(_map_config.SUM_OF_SOURCE_BYTES);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(FlowBadge, {
    color: "hollow"
  }, /*#__PURE__*/_react.default.createElement(EuiFlexGroupStyled, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isSrcDest ? i18n.SOURCE : i18n.CLIENT)))), /*#__PURE__*/_react.default.createElement(_source_destination_arrows.SourceDestinationArrows, {
    contextId: contextId,
    destinationBytes: isSrcDest ? lineProps[_map_config.SUM_OF_DESTINATION_BYTES] : lineProps[_map_config.SUM_OF_SERVER_BYTES],
    eventId: `map-line-tooltip-${contextId}`,
    sourceBytes: isSrcDest ? lineProps[_map_config.SUM_OF_SOURCE_BYTES] : lineProps[_map_config.SUM_OF_CLIENT_BYTES]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(FlowBadge, {
    color: "hollow"
  }, /*#__PURE__*/_react.default.createElement(EuiFlexGroupStyled, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isSrcDest ? i18n.DESTINATION : i18n.SERVER)))));
};
exports.LineToolTipContentComponent = LineToolTipContentComponent;
LineToolTipContentComponent.displayName = 'LineToolTipContentComponent';
const LineToolTipContent = exports.LineToolTipContent = /*#__PURE__*/_react.default.memo(LineToolTipContentComponent);
LineToolTipContent.displayName = 'LineToolTipContent';