"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEmbeddable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _uuid = require("uuid");
var _react = _interopRequireDefault(require("react"));
var _reactReversePortal = require("react-reverse-portal");
var _public = require("@kbn/maps-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _map_config = require("./map_config");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates MapEmbeddable with provided initial configuration
 *
 * @param filters any existing global filters
 * @param indexPatterns list of index patterns to configure layers for
 * @param query initial query constraints as Query
 * @param startDate
 * @param endDate
 * @param setQuery function as provided by the GlobalTime component for reacting to refresh
 * @param portalNode wrapper for MapToolTip so it is not rendered in the embeddables component tree
 * @param embeddableApi
 *
 * @throws Error if EmbeddableFactory does not exist
 */
const createEmbeddable = async (filters, indexPatterns, query, startDate, endDate, setQuery, portalNode, embeddableApi) => {
  const factory = embeddableApi.getEmbeddableFactory(_public.MAP_SAVED_OBJECT_TYPE);
  if (!factory) {
    throw new Error('Map embeddable factory undefined');
  }
  const input = {
    title: i18n.MAP_TITLE,
    attributes: {
      title: ''
    },
    id: (0, _uuid.v4)(),
    filters,
    hidePanelTitles: true,
    query,
    timeRange: {
      from: new Date(startDate).toISOString(),
      to: new Date(endDate).toISOString()
    },
    viewMode: _public2.ViewMode.VIEW,
    isLayerTOCOpen: false,
    openTOCDetails: [],
    hideFilterActions: false,
    mapCenter: {
      lon: -1.05469,
      lat: 15.96133,
      zoom: 1
    },
    disabledActions: ['CUSTOM_TIME_RANGE', 'CUSTOM_TIME_RANGE_BADGE']
  };
  const renderTooltipContent = ({
    addFilters,
    closeTooltip,
    features,
    isLocked,
    getLayerName,
    loadFeatureProperties,
    loadFeatureGeometry
  }) => {
    const props = {
      addFilters,
      closeTooltip,
      features,
      isLocked,
      getLayerName,
      loadFeatureProperties,
      loadFeatureGeometry
    };
    return /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, (0, _extends2.default)({
      node: portalNode
    }, props));
  };
  const embeddableObject = await factory.create(input);
  if (!embeddableObject) {
    throw new Error('Map embeddable is undefined');
  }
  if (!(0, _public2.isErrorEmbeddable)(embeddableObject)) {
    embeddableObject.setRenderTooltipContent(renderTooltipContent);
    // @ts-expect-error
    embeddableObject.setLayerList((0, _map_config.getLayerList)(indexPatterns));
  }

  // Wire up to app refresh action
  setQuery({
    id: 'embeddedMap',
    // Scope to page type if using map elsewhere
    inspect: null,
    loading: false,
    refetch: () => embeddableObject.reload()
  });
  return embeddableObject;
};
exports.createEmbeddable = createEmbeddable;