"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRiskScoreSummaryAttributes = void 0;
var _uuid = require("uuid");
var _capitalize = _interopRequireDefault(require("lodash/capitalize"));
var _utils = require("../common/utils");
var _search_strategy = require("../../../common/search_strategy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRiskScoreSummaryAttributes = ({
  spaceId,
  query,
  severity,
  riskEntity
}) => {
  const layerIds = [(0, _uuid.v4)(), (0, _uuid.v4)()];
  const internalReferenceId = (0, _uuid.v4)();
  const columnIds = [(0, _uuid.v4)(), (0, _uuid.v4)(), (0, _uuid.v4)()];
  const sourceField = riskEntity === _search_strategy.RiskScoreEntity.user ? _search_strategy.RiskScoreFields.userRiskScore : _search_strategy.RiskScoreFields.hostRiskScore;
  return {
    title: 'Risk score summary',
    description: '',
    visualizationType: 'lnsMetric',
    state: {
      visualization: {
        layerId: layerIds[0],
        layerType: 'data',
        metricAccessor: columnIds[0],
        trendlineLayerId: layerIds[1],
        trendlineLayerType: 'metricTrendline',
        trendlineTimeAccessor: columnIds[1],
        trendlineMetricAccessor: columnIds[2],
        palette: {
          type: 'palette',
          name: 'custom',
          params: {
            steps: 3,
            name: 'custom',
            reverse: false,
            rangeType: 'number',
            rangeMin: 0,
            rangeMax: null,
            progression: 'fixed',
            colorStops: _utils.SEVERITY_UI_SORT_ORDER.map(riskSeverity => ({
              color: _utils.RISK_SEVERITY_COLOUR[riskSeverity],
              stop: _utils.RISK_SCORE_RANGES[riskSeverity].start
            })),
            stops: _utils.SEVERITY_UI_SORT_ORDER.map(riskSeverity => ({
              color: _utils.RISK_SEVERITY_COLOUR[riskSeverity],
              stop: _utils.RISK_SCORE_RANGES[riskSeverity].stop
            })),
            continuity: 'above',
            maxSteps: 5
          }
        },
        subtitle: severity
      },
      query: {
        query: query !== null && query !== void 0 ? query : '',
        language: 'kuery'
      },
      filters: [],
      datasourceStates: {
        formBased: {
          layers: {
            [layerIds[0]]: {
              columns: {
                [columnIds[0]]: {
                  label: `${(0, _capitalize.default)(riskEntity)} Risk`,
                  dataType: 'number',
                  operationType: 'last_value',
                  isBucketed: false,
                  scale: 'ratio',
                  sourceField,
                  reducedTimeRange: '',
                  params: {
                    sortField: '@timestamp',
                    format: {
                      id: 'number',
                      params: {
                        decimals: 2,
                        compact: false
                      }
                    },
                    emptyAsNull: true
                  },
                  customLabel: true
                }
              },
              columnOrder: [columnIds[0]],
              incompleteColumns: {}
            },
            [layerIds[1]]: {
              linkToLayers: [layerIds[0]],
              columns: {
                [columnIds[1]]: {
                  label: '@timestamp',
                  dataType: 'date',
                  operationType: 'date_histogram',
                  sourceField: _search_strategy.RiskScoreFields.timestamp,
                  isBucketed: true,
                  scale: 'interval',
                  params: {
                    interval: 'auto',
                    includeEmptyRows: true,
                    dropPartials: false
                  }
                },
                [columnIds[2]]: {
                  label: 'Risk value',
                  dataType: 'number',
                  operationType: 'last_value',
                  isBucketed: false,
                  scale: 'ratio',
                  sourceField,
                  filter: {
                    query: '',
                    language: 'kuery'
                  },
                  timeShift: '',
                  reducedTimeRange: '',
                  params: {
                    sortField: '@timestamp',
                    format: {
                      id: 'number',
                      params: {
                        decimals: 0,
                        compact: false
                      }
                    }
                  },
                  customLabel: true
                }
              },
              columnOrder: [columnIds[1], columnIds[2]],
              sampling: 1,
              ignoreGlobalFilters: false,
              incompleteColumns: {}
            }
          }
        },
        indexpattern: {
          layers: {}
        },
        textBased: {
          layers: {}
        }
      },
      internalReferences: [{
        type: 'index-pattern',
        id: internalReferenceId,
        name: `indexpattern-datasource-layer-${layerIds[0]}`
      }, {
        type: 'index-pattern',
        id: internalReferenceId,
        name: `indexpattern-datasource-layer-${layerIds[1]}`
      }],
      adHocDataViews: {
        [internalReferenceId]: {
          id: internalReferenceId,
          title: `risk-score.risk-score-${spaceId !== null && spaceId !== void 0 ? spaceId : 'default'}`,
          timeFieldName: '@timestamp',
          sourceFilters: [],
          fieldFormats: {},
          runtimeFieldMap: {},
          fieldAttrs: {},
          allowNoIndex: false,
          name: `risk-score.risk-score-${spaceId !== null && spaceId !== void 0 ? spaceId : 'default'}`
        }
      }
    },
    references: []
  };
};
exports.getRiskScoreSummaryAttributes = getRiskScoreSummaryAttributes;