"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeverityFilterGroup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _utils = require("../../common/utils");
var _common = require("./common");
var _translations = require("../risk_score/translations");
var _kibana = require("../../../common/lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SEVERITY_FILTER_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.severityFilter.ariaLabel', {
  defaultMessage: 'Select the severity level to filter by'
});
const SeverityFilterGroup = ({
  severityCount,
  selectedSeverities,
  onSelect,
  riskEntity
}) => {
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => {
    setIsPopoverOpen(!isPopoverOpen);
  }, [isPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const filterGroupPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'filterGroupPopover'
  });
  const items = (0, _react.useMemo)(() => {
    const checked = 'on';
    return _utils.SEVERITY_UI_SORT_ORDER.map(severity => ({
      risk: severity,
      count: severityCount[severity],
      label: severity,
      checked: selectedSeverities.includes(severity) ? checked : undefined
    }));
  }, [severityCount, selectedSeverities]);
  const updateSeverityFilter = (0, _react.useCallback)((newSelection, _, changedSeverity) => {
    if (changedSeverity.checked === 'on') {
      telemetry.reportEntityRiskFiltered({
        entity: riskEntity,
        selectedSeverity: changedSeverity.risk
      });
    }
    const newSelectedSeverities = newSelection.filter(item => item.checked === 'on').map(item => item.risk);
    onSelect(newSelectedSeverities);
  }, [onSelect, riskEntity, telemetry]);
  const totalActiveItem = (0, _react.useMemo)(() => items.reduce((total, item) => item.checked === 'on' ? total + item.count : total, 0), [items]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    "data-test-subj": "risk-filter-button",
    hasActiveFilters: !!items.find(item => item.checked === 'on'),
    iconType: "arrowDown",
    isSelected: isPopoverOpen,
    numActiveFilters: totalActiveItem,
    onClick: onButtonClick
  }, (0, _translations.ENTITY_RISK_LEVEL)(riskEntity)), [isPopoverOpen, items, onButtonClick, totalActiveItem, riskEntity]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: filterGroupPopoverId,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": SEVERITY_FILTER_ARIA_LABEL,
    options: items,
    onChange: updateSeverityFilter,
    "data-test-subj": "risk-filter-selectable",
    renderOption: item => /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
      "data-test-subj": `risk-filter-item-${item.risk}`,
      severity: item.risk
    })
  }, list => /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 150
    }
  }, list))));
};
exports.SeverityFilterGroup = SeverityFilterGroup;