"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreLevel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _uiTheme = require("@kbn/ui-theme");
var _utils = require("../../../common/utils");
var _with_hover_actions = require("../../../../common/components/with_hover_actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RiskBadge = _styledComponents.default.div`
  ${({
  theme,
  $severity,
  $hideBackgroundColor
}) => (0, _styledComponents.css)`
    width: fit-content;
    padding-right: ${theme.eui.euiSizeS};
    padding-left: ${theme.eui.euiSizeXS};

    ${($severity === 'Critical' || $severity === 'High') && !$hideBackgroundColor && (0, _styledComponents.css)`
      background-color: ${(0, _eui.transparentize)(theme.eui.euiColorDanger, 0.2)};
      border-radius: 999px; // pill shaped
    `};
  `}
`;
const TooltipContainer = _styledComponents.default.div`
  padding: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const RiskScoreLevel = ({
  severity,
  hideBackgroundColor = false,
  toolTipContent,
  'data-test-subj': dataTestSubj
}) => {
  const badge = /*#__PURE__*/_react.default.createElement(RiskBadge, {
    color: _uiTheme.euiLightVars.euiColorDanger,
    $severity: severity,
    $hideBackgroundColor: hideBackgroundColor,
    "data-test-subj": dataTestSubj !== null && dataTestSubj !== void 0 ? dataTestSubj : 'risk-score'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "default"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    className: "eui-alignMiddle",
    color: _utils.RISK_SEVERITY_COLOUR[severity]
  }, severity)));
  if (toolTipContent != null) {
    return /*#__PURE__*/_react.default.createElement(_with_hover_actions.WithHoverActions, {
      hoverContent: /*#__PURE__*/_react.default.createElement(TooltipContainer, null, toolTipContent),
      render: () => badge
    });
  }
  return badge;
};
exports.RiskScoreLevel = RiskScoreLevel;