"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScorePreviewSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _i18nReact = require("@kbn/i18n-react");
var _risk_engine = require("../../../common/entity_analytics/risk_engine");
var _risk_score_preview_table = require("./risk_score_preview_table");
var i18n = _interopRequireWildcard(require("../translations"));
var _use_preview_risk_scores = require("../api/hooks/use_preview_risk_scores");
var _kibana = require("../../common/lib/kibana");
var _model = require("../../common/store/sourcerer/model");
var _sourcerer = require("../../common/containers/sourcerer");
var _use_app_toasts = require("../../common/hooks/use_app_toasts");
var _common = require("../common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRiskiestScores = (scores = [], field) => {
  var _scores$filter, _scores$filter$sort;
  return (scores === null || scores === void 0 ? void 0 : (_scores$filter = scores.filter(item => (item === null || item === void 0 ? void 0 : item.id_field) === field)) === null || _scores$filter === void 0 ? void 0 : (_scores$filter$sort = _scores$filter.sort((a, b) => (b === null || b === void 0 ? void 0 : b.calculated_score_norm) - (a === null || a === void 0 ? void 0 : a.calculated_score_norm))) === null || _scores$filter$sort === void 0 ? void 0 : _scores$filter$sort.slice(0, 5)) || [];
};
const RiskScorePreviewSection = ({
  privileges
}) => {
  const sectionBody = (0, _react.useMemo)(() => {
    if (privileges.isLoading) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "xl"
      })));
    }
    if ((0, _common.userHasRiskEngineReadPermissions)(privileges)) {
      return /*#__PURE__*/_react.default.createElement(RiskEnginePreview, null);
    }
    return /*#__PURE__*/_react.default.createElement(MissingPermissionsCallout, null);
  }, [privileges]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, i18n.PREVIEW)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's'
  }), sectionBody);
};
exports.RiskScorePreviewSection = RiskScorePreviewSection;
const MissingPermissionsCallout = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.PREVIEW_MISSING_PERMISSIONS_TITLE,
    color: "primary",
    iconType: "iInCircle",
    "data-test-subj": "missing-risk-engine-preview-permissions"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskScore.riskScorePreview.missingPermissionsCallout.description",
    defaultMessage: "Read permission is required for the {index} index pattern in order to preview data. Contact your administrator for further assistance.",
    values: {
      index: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, _risk_engine.RISK_SCORE_INDEX_PATTERN)
    }
  })));
};
const RiskScorePreviewPanel = ({
  items,
  showMessage,
  hideMessage,
  isLoading,
  type
}) => {
  const [trigger, setTrigger] = (0, _react.useState)('open');
  const onToggle = isOpen => {
    const newState = isOpen ? 'open' : 'closed';
    setTrigger(newState);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: true,
    isLoading: isLoading,
    id: 'host-table',
    buttonContent: trigger === 'closed' ? showMessage : hideMessage,
    forceState: trigger,
    onToggle: onToggle,
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: type === _risk_engine.RiskScoreEntity.host ? 'storage' : 'user'
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm'
  }), /*#__PURE__*/_react.default.createElement(_risk_score_preview_table.RiskScorePreviewTable, {
    items: items,
    type: type
  }))));
};
const RiskEnginePreview = () => {
  const [dateRange, setDateRange] = (0, _react.useState)({
    from: 'now-24h',
    to: 'now'
  });
  const [filters, setFilters] = (0, _react.useState)({
    bool: {
      must: [],
      filter: [],
      should: [],
      must_not: []
    }
  });
  const {
    unifiedSearch: {
      ui: {
        SearchBar
      }
    }
  } = (0, _kibana.useKibana)().services;
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    indexPattern
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.detections);
  const {
    data,
    isLoading,
    refetch,
    isError
  } = (0, _use_preview_risk_scores.useRiskScorePreview)({
    data_view_id: indexPattern.title,
    // TODO @nkhristinin verify this is correct
    filter: filters,
    range: {
      start: dateRange.from,
      end: dateRange.to
    }
  });
  const hosts = getRiskiestScores(data === null || data === void 0 ? void 0 : data.scores.host, 'host.name');
  const users = getRiskiestScores(data === null || data === void 0 ? void 0 : data.scores.user, 'user.name');
  const onQuerySubmit = (0, _react.useCallback)(payload => {
    setDateRange({
      from: payload.dateRange.from,
      to: payload.dateRange.to
    });
    try {
      var _payload$query;
      const newFilters = (0, _esQuery.buildEsQuery)(undefined, (_payload$query = payload.query) !== null && _payload$query !== void 0 ? _payload$query : {
        query: '',
        language: 'kuery'
      }, []);
      setFilters(newFilters);
    } catch (e) {
      addError(e, {
        title: i18n.PREVIEW_QUERY_ERROR_TITLE
      });
    }
  }, [addError, setDateRange, setFilters]);
  if (isError) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      "data-test-subj": "risk-preview-error",
      title: i18n.PREVIEW_ERROR_TITLE,
      color: "danger",
      iconType: "error"
    }, /*#__PURE__*/_react.default.createElement("p", null, i18n.PREVIEW_ERROR_MESSAGE), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "risk-preview-error-button",
      color: "danger",
      onClick: () => refetch()
    }, i18n.PREVIEW_ERROR_TRY_AGAIN));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, i18n.PREVIEW_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    "data-test-subj": "risk-score-preview-search-bar"
  }, indexPattern && /*#__PURE__*/_react.default.createElement(SearchBar, {
    appName: "siem",
    isLoading: isLoading,
    indexPatterns: [indexPattern],
    dateRangeFrom: dateRange.from,
    dateRangeTo: dateRange.to,
    onQuerySubmit: onQuerySubmit,
    showFilterBar: false,
    showDatePicker: true,
    displayStyle: 'inPage',
    submitButtonStyle: 'iconOnly'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(RiskScorePreviewPanel, {
    items: hosts,
    showMessage: i18n.SHOW_HOSTS_RISK_SCORE,
    hideMessage: i18n.HIDE_HOSTS_RISK_SCORE,
    isLoading: isLoading,
    type: _risk_engine.RiskScoreEntity.host
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(RiskScorePreviewPanel, {
    items: users,
    showMessage: i18n.SHOW_USERS_RISK_SCORE,
    hideMessage: i18n.HIDE_USERS_RISK_SCORE,
    isLoading: isLoading,
    type: _risk_engine.RiskScoreEntity.user
  }));
};