"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scoreFormatter = exports.RiskScoreOverTime = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _header_section = require("../../../common/components/header_section");
var _inspect = require("../../../common/components/inspect");
var _use_space_id = require("../../../common/hooks/use_space_id");
var _visualization_embeddable = require("../../../common/components/visualization_actions/visualization_embeddable");
var _risk_score_over_time_area = require("../../lens_attributes/risk_score_over_time_area");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CHART_HEIGHT = 180;
const scoreFormatter = d => Math.round(d).toString();
exports.scoreFormatter = scoreFormatter;
const RiskScoreOverTimeComponent = ({
  from,
  to,
  riskScore,
  loading,
  queryId,
  riskEntity,
  title,
  toggleStatus,
  toggleQuery
}) => {
  const spaceId = (0, _use_space_id.useSpaceId)();
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": "RiskScoreOverTime"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'none'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: title,
    hideSubtitle: true,
    toggleQuery: toggleQuery,
    toggleStatus: toggleStatus
  }))), toggleStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, spaceId && /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    applyGlobalQueriesAndFilters: false,
    timerange: timerange,
    getLensAttributes: _risk_score_over_time_area.getRiskScoreOverTimeAreaAttributes,
    stackByField: riskEntity,
    id: `${queryId}-embeddable`,
    height: CHART_HEIGHT,
    extraOptions: {
      spaceId
    }
  })))));
};
RiskScoreOverTimeComponent.displayName = 'RiskScoreOverTimeComponent';
const RiskScoreOverTime = exports.RiskScoreOverTime = /*#__PURE__*/_react.default.memo(RiskScoreOverTimeComponent);
RiskScoreOverTime.displayName = 'RiskScoreOverTime';