"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRiskScoreToastContent = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _risk_score_doc_link = require("./risk_score_doc_link");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledButton = (0, _styledComponents.default)(_eui.EuiButton)`
  float: right;
`;
const useRiskScoreToastContent = riskScoreEntity => {
  const renderDocLink = (0, _react.useCallback)(message => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, message, " ", /*#__PURE__*/_react.default.createElement(_risk_score_doc_link.RiskScoreDocLink, {
    riskScoreEntity: riskScoreEntity
  })), [riskScoreEntity]);
  const renderDashboardLink = (0, _react.useCallback)((message, targetUrl) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, message, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(StyledButton, {
    href: targetUrl,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.risk_score.toast.viewDashboard",
    defaultMessage: "View dashboard"
  }))), []);
  const renderLinks = (0, _react.useMemo)(() => ({
    renderDocLink,
    renderDashboardLink
  }), [renderDashboardLink, renderDocLink]);
  return renderLinks;
};
exports.useRiskScoreToastContent = useRiskScoreToastContent;