"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USER_WARNING_TITLE = exports.USER_WARNING_BODY = exports.RISK_DATA_TITLE = exports.RESTART_TOOLTIP = exports.HOST_WARNING_TITLE = exports.HOST_WARNING_BODY = exports.BETA = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../risk_score/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BETA = exports.BETA = _i18n.i18n.translate('xpack.securitySolution.riskScore.technicalPreviewLabel', {
  defaultMessage: 'Beta'
});
const HOST_WARNING_TITLE = exports.HOST_WARNING_TITLE = _i18n.i18n.translate('xpack.securitySolution.riskScore.hostsDashboardWarningPanelTitle', {
  defaultMessage: 'No host risk score data available to display'
});
const USER_WARNING_TITLE = exports.USER_WARNING_TITLE = _i18n.i18n.translate('xpack.securitySolution.riskScore.usersDashboardWarningPanelTitle', {
  defaultMessage: 'No user risk score data available to display'
});
const HOST_WARNING_BODY = exports.HOST_WARNING_BODY = _i18n.i18n.translate('xpack.securitySolution.riskScore.hostsDashboardWarningPanelBody', {
  defaultMessage: `We haven’t found any host risk score data. Check if you have any global filters in the global KQL search bar. If you have just enabled the host risk module, the risk engine might need an hour to generate host risk score data and display in this panel.`
});
const USER_WARNING_BODY = exports.USER_WARNING_BODY = _i18n.i18n.translate('xpack.securitySolution.riskScore.usersDashboardWarningPanelBody', {
  defaultMessage: `We haven’t found any user risk score data. Check if you have any global filters in the global KQL search bar. If you have just enabled the user risk module, the risk engine might need an hour to generate user risk score data and display in this panel.`
});
const RESTART_TOOLTIP = exports.RESTART_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.riskScore.usersDashboardRestartTooltip', {
  defaultMessage: 'The risk score calculation might take a while to run. However, by pressing restart, you can force it to run immediately.'
});
const RISK_DATA_TITLE = riskEntity => _i18n.i18n.translate('xpack.securitySolution.alertDetails.overview.hostRiskDataTitle', {
  defaultMessage: '{riskEntity} Risk Data',
  values: {
    riskEntity: (0, _translations.getRiskEntityTranslation)(riskEntity)
  }
});
exports.RISK_DATA_TITLE = RISK_DATA_TITLE;