"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreEnableButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_space_id = require("../../../common/hooks/use_space_id");
var _kibana = require("../../../common/lib/kibana");
var _use_fetch = require("../../../common/hooks/use_fetch");
var _use_risk_score_toast_content = require("./use_risk_score_toast_content");
var _utils = require("./utils");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _links = require("../../../common/components/links");
var _constants = require("../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RiskScoreEnableButtonComponent = ({
  refetch,
  riskScoreEntity,
  disabled = false,
  timerange
}) => {
  const spaceId = (0, _use_space_id.useSpaceId)();
  const {
    http,
    notifications,
    theme,
    dashboard
  } = (0, _kibana.useKibana)().services;
  const {
    renderDocLink,
    renderDashboardLink
  } = (0, _use_risk_score_toast_content.useRiskScoreToastContent)(riskScoreEntity);
  const {
    fetch,
    isLoading
  } = (0, _use_fetch.useFetch)(_use_fetch.REQUEST_NAMES.ENABLE_RISK_SCORE, _utils.installRiskScoreModule);
  const isRiskEngineEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('riskScoringRoutesEnabled');
  const onBoardingRiskScore = (0, _react.useCallback)(() => {
    fetch({
      dashboard,
      http,
      notifications,
      refetch,
      renderDashboardLink,
      renderDocLink,
      riskScoreEntity,
      spaceId,
      theme,
      timerange
    });
  }, [dashboard, fetch, http, notifications, refetch, renderDashboardLink, renderDocLink, riskScoreEntity, spaceId, theme, timerange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isRiskEngineEnabled ? /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkButton, {
    color: "primary",
    fill: true,
    deepLinkId: _constants.SecurityPageName.entityAnalyticsManagement,
    "data-test-subj": `enable_${riskScoreEntity}_risk_score`
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskScore.enableButtonTitle",
    defaultMessage: "Enable"
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    onClick: onBoardingRiskScore,
    isLoading: isLoading,
    "data-test-subj": `enable_${riskScoreEntity}_risk_score`,
    disabled: disabled
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskScore.enableButtonTitle",
    defaultMessage: "Enable"
  })));
};
const RiskScoreEnableButton = exports.RiskScoreEnableButton = /*#__PURE__*/_react.default.memo(RiskScoreEnableButtonComponent);
RiskScoreEnableButton.displayName = 'RiskScoreEnableButton';