"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreDocLink = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _search_strategy = require("../../../../common/search_strategy");
var _kibana = require("../../../common/lib/kibana");
var _translations = require("../entity_analytics_risk_score/translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLearnMoreLinkForEntity = riskScoreEntity => {
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const entityAnalyticsLinks = docLinks.links.securitySolution.entityAnalytics;
  return (0, _react.useMemo)(() => {
    if (!riskScoreEntity) {
      return entityAnalyticsLinks.entityRiskScoring;
    }
    if (riskScoreEntity === _search_strategy.RiskScoreEntity.user) {
      return entityAnalyticsLinks.userRiskScore;
    }
    return entityAnalyticsLinks.hostRiskScore;
  }, [riskScoreEntity, entityAnalyticsLinks]);
};
const RiskScoreDocLinkComponent = ({
  riskScoreEntity,
  title
}) => {
  const learnMoreLink = useLearnMoreLinkForEntity(riskScoreEntity);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    rel: "noopener nofollow noreferrer",
    href: learnMoreLink
  }, title ? title : (0, _translations.LEARN_MORE)(riskScoreEntity));
};
const RiskScoreDocLink = exports.RiskScoreDocLink = /*#__PURE__*/_react.default.memo(RiskScoreDocLinkComponent);
RiskScoreDocLink.displayName = 'RiskScoreDocLink';