"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskEnginePrivilegesCallOut = void 0;
var _react = _interopRequireDefault(require("react"));
var _callouts = require("../../../common/components/callouts");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RiskEnginePrivilegesCallOut = ({
  privileges
}) => {
  if (privileges.isLoading || privileges.hasAllRequiredPrivileges) {
    return null;
  }
  const message = {
    type: 'primary',
    id: `missing-risk-engine-privileges`,
    title: _translations.MISSING_PRIVILEGES_CALLOUT_TITLE,
    description: /*#__PURE__*/_react.default.createElement(_translations.MissingPrivilegesCallOutBody, privileges.missingPrivileges)
  };
  return message && /*#__PURE__*/_react.default.createElement(_callouts.CallOutSwitcher, {
    namespace: "entity_analytics",
    condition: true,
    message: message
  });
};
exports.RiskEnginePrivilegesCallOut = RiskEnginePrivilegesCallOut;