"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rowItems = exports.HostRiskScoreTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _paginated_table = require("../../../explore/components/paginated_table");
var _use_selector = require("../../../common/hooks/use_selector");
var _store = require("../../../explore/hosts/store");
var _columns = require("./columns");
var _search_strategy = require("../../../../common/search_strategy");
var i18n = _interopRequireWildcard(require("../../../explore/hosts/components/hosts_table/translations"));
var i18nHosts = _interopRequireWildcard(require("./translations"));
var _severity_badges = require("../severity/severity_badges");
var _severity_bar = require("../severity/severity_bar");
var _severity_filter_group = require("../severity/severity_filter_group");
var _risk_information = require("../risk_information");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rowItems = exports.rowItems = [{
  text: i18n.ROWS_5,
  numberOfRow: 5
}, {
  text: i18n.ROWS_10,
  numberOfRow: 10
}];
const tableType = _store.hostsModel.HostsTableType.risk;
const HostRiskScoreTableComponent = ({
  data,
  id,
  isInspect,
  loading,
  loadPage,
  setQuerySkip,
  severityCount,
  totalCount,
  type
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getHostRiskScoreSelector = (0, _react.useMemo)(() => _store.hostsSelectors.hostRiskScoreSelector(), []);
  const {
    activePage,
    limit,
    sort
  } = (0, _use_selector.useDeepEqualSelector)(state => getHostRiskScoreSelector(state, _store.hostsModel.HostsType.page));
  const updateLimitPagination = (0, _react.useCallback)(newLimit => dispatch(_store.hostsActions.updateTableLimit({
    hostsType: type,
    limit: newLimit,
    tableType
  })), [type, dispatch]);
  const updateActivePage = (0, _react.useCallback)(newPage => dispatch(_store.hostsActions.updateTableActivePage({
    activePage: newPage,
    hostsType: type,
    tableType
  })), [type, dispatch]);
  const onSort = (0, _react.useCallback)(criteria => {
    if (criteria.sort != null) {
      const newSort = criteria.sort;
      if (newSort.direction !== sort.direction || newSort.field !== sort.field) {
        dispatch(_store.hostsActions.updateHostRiskScoreSort({
          sort: newSort,
          hostsType: type
        }));
      }
    }
  }, [dispatch, sort, type]);
  const dispatchSeverityUpdate = (0, _react.useCallback)(s => {
    dispatch(_store.hostsActions.updateHostRiskScoreSeverityFilter({
      severitySelection: [s],
      hostsType: type
    }));
  }, [dispatch, type]);
  const columns = (0, _react.useMemo)(() => (0, _columns.getHostRiskScoreColumns)({
    dispatchSeverityUpdate
  }), [dispatchSeverityUpdate]);
  const risk = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_severity_badges.SeverityBadges, {
    severityCount: severityCount
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_severity_bar.SeverityBar, {
    severityCount: severityCount
  })));
  const getHostRiskScoreFilterQuerySelector = (0, _react.useMemo)(() => _store.hostsSelectors.hostRiskScoreSeverityFilterSelector(), []);
  const severitySelectionRedux = (0, _use_selector.useDeepEqualSelector)(state => getHostRiskScoreFilterQuerySelector(state, type));
  const onSelect = (0, _react.useCallback)(newSelection => {
    dispatch(_store.hostsActions.updateHostRiskScoreSeverityFilter({
      severitySelection: newSelection,
      hostsType: type
    }));
  }, [dispatch, type]);
  return /*#__PURE__*/_react.default.createElement(_paginated_table.PaginatedTable, {
    activePage: activePage,
    columns: columns,
    dataTestSubj: `table-${tableType}`,
    headerCount: totalCount,
    headerFilters: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_risk_information.RiskInformationButtonEmpty, {
      riskEntity: _search_strategy.RiskScoreEntity.host
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_severity_filter_group.SeverityFilterGroup, {
      selectedSeverities: severitySelectionRedux,
      severityCount: severityCount,
      onSelect: onSelect,
      riskEntity: _search_strategy.RiskScoreEntity.host
    }))),
    headerSupplement: risk,
    headerTitle: i18nHosts.HOST_RISK_TITLE,
    headerUnit: i18n.UNIT(totalCount),
    id: id,
    isInspect: isInspect,
    itemsPerRow: rowItems,
    limit: limit,
    loading: loading,
    loadPage: loadPage,
    onChange: onSort,
    pageOfItems: data,
    setQuerySkip: setQuerySkip,
    showMorePagesIndicator: false,
    sorting: sort,
    split: true,
    stackHeader: true,
    totalCount: totalCount,
    updateLimitPagination: updateLimitPagination,
    updateActivePage: updateActivePage
  });
};
HostRiskScoreTableComponent.displayName = 'HostRiskScoreTableComponent';
const HostRiskScoreTable = exports.HostRiskScoreTable = /*#__PURE__*/_react.default.memo(HostRiskScoreTableComponent);
HostRiskScoreTable.displayName = 'HostRiskScoreTable';