"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRiskInputTab = exports.RISK_INPUTS_TAB_TEST_ID = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _left_panel_header = require("../../../flyout/entity_details/shared/components/left_panel/left_panel_header");
var _test_ids = require("../../../flyout/shared/test_ids");
var _risk_inputs_tab = require("./tabs/risk_inputs/risk_inputs_tab");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RISK_INPUTS_TAB_TEST_ID = exports.RISK_INPUTS_TAB_TEST_ID = `${_test_ids.PREFIX}RiskInputsTab`;
const getRiskInputTab = ({
  entityType,
  entityName
}) => ({
  id: _left_panel_header.EntityDetailsLeftPanelTab.RISK_INPUTS,
  'data-test-subj': RISK_INPUTS_TAB_TEST_ID,
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.userDetails.riskInputs.tabLabel",
    defaultMessage: "Risk contributions"
  }),
  content: /*#__PURE__*/_react.default.createElement(_risk_inputs_tab.RiskInputsTab, {
    entityType: entityType,
    entityName: entityName
  })
});
exports.getRiskInputTab = getRiskInputTab;