"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRiskScoreColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _empty_value = require("../../../common/components/empty_value");
var _links = require("../../../common/components/links");
var _common = require("../severity/common");
var _constants = require("../risk_score/constants");
var _search_strategy = require("../../../../common/search_strategy");
var i18n = _interopRequireWildcard(require("./translations"));
var _formatted_number = require("../../../common/components/formatted_number");
var _cell_actions = require("../../../common/components/cell_actions");
var _formatted_date = require("../../../common/components/formatted_date");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledCellActions = (0, _styledComponents.default)(_cell_actions.SecurityCellActions)`
  padding-left: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const getRiskScoreColumns = (riskEntity, openEntityOnAlertsPage, openEntityOnExpandableFlyout) => [{
  field: riskEntity === _search_strategy.RiskScoreEntity.host ? 'host.name' : 'user.name',
  name: i18n.ENTITY_NAME(riskEntity),
  truncateText: false,
  mobileOptions: {
    show: true
  },
  className: 'inline-actions-table-cell',
  render: entityName => {
    const onEntityDetailsLinkClick = e => {
      e.preventDefault();
      openEntityOnExpandableFlyout(entityName);
    };
    if (entityName != null && entityName.length > 0) {
      return riskEntity === _search_strategy.RiskScoreEntity.host ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
        hostName: entityName,
        onClick: onEntityDetailsLinkClick
      }), /*#__PURE__*/_react.default.createElement(StyledCellActions, {
        data: {
          value: entityName,
          field: 'host.name'
        },
        triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
        mode: _cell_actions.CellActionsMode.INLINE,
        visibleCellActions: 2,
        disabledActionTypes: [_cell_actions.SecurityCellActionType.FILTER, _cell_actions.SecurityCellActionType.SHOW_TOP_N],
        metadata: {
          telemetry: _constants.CELL_ACTIONS_TELEMETRY
        }
      })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_links.UserDetailsLink, {
        userName: entityName,
        onClick: onEntityDetailsLinkClick
      }), /*#__PURE__*/_react.default.createElement(StyledCellActions, {
        data: {
          value: entityName,
          field: 'user.name'
        },
        triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
        mode: _cell_actions.CellActionsMode.INLINE,
        disabledActionTypes: [_cell_actions.SecurityCellActionType.FILTER, _cell_actions.SecurityCellActionType.SHOW_TOP_N]
      }));
    }
    return (0, _empty_value.getEmptyTagValue)();
  }
}, {
  field: _search_strategy.RiskScoreFields.timestamp,
  name: i18n.LAST_UPDATED,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  sortable: true,
  width: '20%',
  render: lastSeen => {
    if (lastSeen != null) {
      return /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
        value: lastSeen
      });
    }
    return (0, _empty_value.getEmptyTagValue)();
  }
}, {
  field: riskEntity === _search_strategy.RiskScoreEntity.host ? _search_strategy.RiskScoreFields.hostRiskScore : _search_strategy.RiskScoreFields.userRiskScore,
  width: '15%',
  name: i18n.RISK_SCORE_TITLE(riskEntity),
  truncateText: true,
  mobileOptions: {
    show: true
  },
  render: riskScore => {
    if (riskScore != null) {
      return /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "risk-score-truncate",
        title: `${riskScore}`
      }, Math.round(riskScore));
    }
    return (0, _empty_value.getEmptyTagValue)();
  }
}, {
  field: riskEntity === _search_strategy.RiskScoreEntity.host ? _search_strategy.RiskScoreFields.hostRisk : _search_strategy.RiskScoreFields.userRisk,
  width: '25%',
  name: i18n.ENTITY_RISK_LEVEL(riskEntity),
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: risk => {
    if (risk != null) {
      return /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
        severity: risk
      });
    }
    return (0, _empty_value.getEmptyTagValue)();
  }
}, {
  field: _search_strategy.RiskScoreFields.alertsCount,
  width: '10%',
  name: i18n.ALERTS,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  className: 'inline-actions-table-cell',
  render: (alertCount, risk) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "risk-score-alerts",
    disabled: alertCount === 0,
    onClick: () => openEntityOnAlertsPage(riskEntity === _search_strategy.RiskScoreEntity.host ? risk.host.name : risk.user.name)
  }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: alertCount
  })), /*#__PURE__*/_react.default.createElement(StyledCellActions, {
    data: {
      value: riskEntity === _search_strategy.RiskScoreEntity.host ? risk.host.name : risk.user.name,
      field: riskEntity === _search_strategy.RiskScoreEntity.host ? 'host.name' : 'user.name'
    },
    mode: _cell_actions.CellActionsMode.INLINE,
    triggerId: _cell_actions.SecurityCellActionsTrigger.ALERTS_COUNT,
    metadata: {
      andFilters: [{
        field: 'kibana.alert.workflow_status',
        value: 'open'
      }]
    }
  }))
}];
exports.getRiskScoreColumns = getRiskScoreColumns;