"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetCriticalityValidationStep = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _download_blob = require("../../../../common/utils/download_blob");
var _kibana_react = require("../../../../common/lib/kibana/kibana_react");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CODE_BLOCK_HEIGHT = 250;
const INVALID_FILE_NAME = `invalid_asset_criticality.csv`;
const AssetCriticalityValidationStep = exports.AssetCriticalityValidationStep = /*#__PURE__*/_react2.default.memo(({
  validatedFile,
  isLoading,
  onConfirm,
  onReturn
}) => {
  const {
    validLines,
    invalidLines,
    size: fileSize,
    name: fileName
  } = validatedFile;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    telemetry
  } = (0, _kibana_react.useKibana)().services;
  const annotations = (0, _helpers.buildAnnotationsFromError)(invalidLines.errors);
  const onConfirmClick = () => {
    telemetry.reportAssetCriticalityCsvImported({
      file: {
        size: fileSize
      }
    });
    onConfirm();
  };
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "{fileName} preview",
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityValidationStep.fileNamePreviewText",
    values: {
      fileName
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), validLines.count > 0 && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: 'checkInCircleFilled',
    color: "success"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement("span", {
    "data-test-subj": "asset-criticality-validLinesMessage"
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityValidationStep.validLinesMessage",
    defaultMessage: "{validLinesCount, plural, one {{validLinesCountBold} asset criticality will be assigned} other {{validLinesCountBold} asset criticalities will be assigned}}",
    values: {
      validLinesCount: validLines.count,
      validLinesCountBold: /*#__PURE__*/_react2.default.createElement("b", null, validLines.count)
    }
  }))))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    flush: "right",
    onClick: onReturn,
    size: "xs",
    disabled: isLoading
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityValidationStep.chooseAnotherFileText",
    defaultMessage: "Choose another file"
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiCodeBlock, {
    overflowHeight: CODE_BLOCK_HEIGHT,
    lineNumbers: true,
    language: "CSV",
    isVirtualized: true,
    css: (0, _react.css)`
                border: 1px solid ${euiTheme.colors.success};
              `
  }, validLines.text), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), invalidLines.count > 0 && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: 'error',
    color: "danger"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement("span", {
    "data-test-subj": "asset-criticality-invalidLinesMessage"
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityValidationStep.invalidLinesMessage",
    defaultMessage: "{invalidLinesCount, plural, one {{invalidLinesCountBold} line is invalid and won't be assigned} other {{invalidLinesCountBold} lines are invalid and won't be assigned}}",
    values: {
      invalidLinesCount: invalidLines.count,
      invalidLinesCountBold: /*#__PURE__*/_react2.default.createElement("b", null, invalidLines.count)
    }
  }))))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, invalidLines.text && /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "right",
    disabled: isLoading,
    onClick: () => {
      if (invalidLines.text.length > 0) {
        (0, _download_blob.downloadBlob)(new Blob([invalidLines.text]), INVALID_FILE_NAME);
      }
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityValidationStep.downloadCSV",
    defaultMessage: "Download CSV"
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiCodeBlock, {
    overflowHeight: CODE_BLOCK_HEIGHT,
    lineNumbers: {
      annotations
    },
    language: "CSV",
    isVirtualized: true,
    css: (0, _react.css)`
                border: 1px solid ${euiTheme.colors.danger};
              `
  }, invalidLines.text), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "baseline"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onReturn,
    disabled: isLoading
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityValidationStep.backButtonText",
    defaultMessage: "Back"
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: onConfirmClick,
    disabled: validLines.count === 0,
    "data-test-subj": "asset-criticality-assign-button",
    isLoading: isLoading
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityValidationStep.assignButtonText",
    defaultMessage: "Assign"
  })))));
});
AssetCriticalityValidationStep.displayName = 'AssetCriticalityValidationStep';