"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetCriticalityResultStep = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AssetCriticalityResultStep = exports.AssetCriticalityResultStep = /*#__PURE__*/_react.default.memo(({
  result,
  validLinesAsText,
  errorMessage,
  onReturn
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (errorMessage !== undefined) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      "data-test-subj": "asset-criticality-result-step-error",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        defaultMessage: "Asset criticality assignment failed.",
        id: "xpack.securitySolution.entityAnalytics.assetCriticalityResultStep.errorMessage"
      }),
      color: "danger",
      iconType: "error"
    }, errorMessage), /*#__PURE__*/_react.default.createElement(ResultStepFooter, {
      onReturn: onReturn
    }));
  }
  if (result === undefined) {
    return null;
  }
  if (result.stats.failed === 0) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      "data-test-subj": "asset-criticality-result-step-success",
      title: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.assetCriticalityResultStep.successTitle', {
        defaultMessage: 'Success'
      }),
      color: "success",
      iconType: "checkInCircleFilled"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Your asset criticality assignments have been successfully mapped.",
      id: "xpack.securitySolution.entityAnalytics.assetCriticalityResultStep.successMessage"
    })), /*#__PURE__*/_react.default.createElement(ResultStepFooter, {
      onReturn: onReturn
    }));
  }
  const annotations = (0, _helpers.buildAnnotationsFromError)(result.errors);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "asset-criticality-result-step-warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Some asset criticality assignments were unsuccessful due to errors.",
      id: "xpack.securitySolution.entityAnalytics.assetCriticalityResultStep.partialError.title"
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "{assignedCount, plural, one {# asset criticality assignment succeeded.} other {# asset criticality assignments succeeded.}}",
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityResultStep.partialError.assignedEntities",
    values: {
      assignedCount: result.stats.successful
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "{failedCount, plural, one {# asset criticality assignment failed.} other {# asset criticality assignments failed.}}",
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityResultStep.partialError.failedEntities",
    values: {
      failedCount: result.stats.failed
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    overflowHeight: 400,
    language: "CSV",
    isVirtualized: true,
    css: (0, _react2.css)`
            border: 1px solid ${euiTheme.colors.warning};
          `,
    lineNumbers: {
      annotations
    }
  }, validLinesAsText)), /*#__PURE__*/_react.default.createElement(ResultStepFooter, {
    onReturn: onReturn
  }));
});
AssetCriticalityResultStep.displayName = 'AssetCriticalityResultStep';
const ResultStepFooter = ({
  onReturn
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xl"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "flexEnd"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  onClick: onReturn
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  defaultMessage: "Upload another file",
  id: "xpack.securitySolution.entityAnalytics.assetCriticalityResultStep.uploadAnotherFile"
}))));